/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.entity;

import de.governikus.csl.transport.HttpRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringRequest
implements HttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringRequest.class);
    private String value;

    public StringRequest(String value) {
        this.value = value;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getContentEncoding() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        IOUtils.write((String)this.value, (OutputStream)outstream, (String)"UTF-8");
    }

    @Override
    public long getContentLength() {
        try {
            return this.value.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Can't calculate size of string", (Throwable)e);
            return -1L;
        }
    }
}

