/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.entity;

import de.governikus.csl.transport.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class InputStreamRequest
implements HttpRequest {
    private InputStream is;
    private String contentType;
    private String contentEncoding;
    private long contentLength;

    public InputStreamRequest(InputStream is, String contentType, String contentEncoding) {
        this(is, contentType, contentEncoding, -1L);
    }

    public InputStreamRequest(InputStream is, String contentType, String contentEncoding, long contentLength) {
        this.is = is;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.contentLength = contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        IOUtils.copyLarge((InputStream)this.is, (OutputStream)outstream);
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }
}

