/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.entity;

import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.uom.Document;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class DocumentRequest
implements HttpRequest {
    private Document document;
    private String contentType;
    private String contentEncoding;
    private long contentLength;

    public DocumentRequest(Document is, String contentType, String contentEncoding) {
        this(is, contentType, contentEncoding, -1L);
    }

    public DocumentRequest(Document is, String contentType, String contentEncoding, long contentLength) {
        this.document = is;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.contentLength = contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        try (InputStream is = this.document.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)outstream);
        }
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }
}

