/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.entity;

import de.governikus.csl.transport.HttpRequest;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ByteArrayRequest
implements HttpRequest {
    private byte[] data;
    private String contentType;
    private String contentEncoding;

    public ByteArrayRequest(byte[] data, String contentType, String contentEncoding) {
        this.data = data;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public ByteArrayRequest(byte[] data) {
        this.data = data;
        this.contentType = "application/octet-stream";
        this.contentEncoding = "UTF-8";
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        IOUtils.write((byte[])this.data, (OutputStream)outstream);
    }

    @Override
    public long getContentLength() {
        return this.data.length;
    }
}

