/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.uom.configuration.ProxyConfiguration;
import de.governikus.csl.uom.configuration.ProxyConfigurationImpl;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

public class TransportFactoryConfiguration {
    private ProxyConfiguration proxyConfiguration;
    private List<Certificate> trustedServerCerts;
    private KeyStore clientKeystore;
    private String clientKeyAlias;
    private String clientKeyPassword;
    private int maxConnectionsPerHost = 2;
    private int socketTimeout = 30000;
    private int connectionTimeout = 15000;
    private int connectionManagerTimeout = 60000;
    private boolean acceptAllSSLServerCertificates;
    private boolean connectionManagerShared;
    private boolean keepSpan;

    public TransportFactoryConfiguration() {
        this.proxyConfiguration = new ProxyConfigurationImpl();
        this.trustedServerCerts = new ArrayList<Certificate>();
    }

    public TransportFactoryConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        this.trustedServerCerts = new ArrayList<Certificate>();
    }

    public TransportFactoryConfiguration(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null, null);
    }

    public TransportFactoryConfiguration(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this(proxyHost, proxyPort, proxyUser, proxyPass, null);
    }

    public TransportFactoryConfiguration(String proxyHost, int proxyPort, String proxyUser, String proxyPass, List<String> noProxyHosts) {
        this.proxyConfiguration = new ProxyConfigurationImpl(proxyHost, proxyPort, proxyUser, proxyPass, (List)(noProxyHosts == null ? new ArrayList() : noProxyHosts));
        this.trustedServerCerts = new ArrayList<Certificate>();
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public List<Certificate> getTrustedServerCerts() {
        return this.trustedServerCerts;
    }

    public void setTrustedServerCerts(List<Certificate> trustedServerCerts) {
        this.trustedServerCerts = trustedServerCerts;
    }

    public KeyStore getClientKeystore() {
        return this.clientKeystore;
    }

    public void setClientKeystore(KeyStore clientKeystore) {
        this.clientKeystore = clientKeystore;
    }

    public String getClientKeyAlias() {
        return this.clientKeyAlias;
    }

    public void setClientKeyAlias(String clientKeyAlias) {
        this.clientKeyAlias = clientKeyAlias;
    }

    public String getClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public void setClientKeyPassword(String clientKeyPassword) {
        this.clientKeyPassword = clientKeyPassword;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionManagerTimeout() {
        return this.connectionManagerTimeout;
    }

    public void setConnectionManagerTimeout(int connectionManagerTimeout) {
        this.connectionManagerTimeout = connectionManagerTimeout;
    }

    public boolean isAcceptAllSSLServerCertificates() {
        return this.acceptAllSSLServerCertificates;
    }

    public void setAcceptAllSSLServerCertificates(boolean acceptAllSSLServerCertificates) {
        this.acceptAllSSLServerCertificates = acceptAllSSLServerCertificates;
    }

    public boolean isConnectionManagerShared() {
        return this.connectionManagerShared;
    }

    public void setConnectionManagerShared(boolean connectionManagerShared) {
        this.connectionManagerShared = connectionManagerShared;
    }

    public boolean isKeepSpan() {
        return this.keepSpan;
    }

    public void setKeepSpan(boolean keepSpan) {
        this.keepSpan = keepSpan;
    }
}

