/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.AbstractHttpClient;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringResponseHandler
implements HttpResponseHandler<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringResponseHandler.class);

    /*
     * Loose catch block
     */
    @Override
    public String handleResponse(HttpResponse resp) throws IOException {
        AbstractHttpClient.checkResponseErrors(resp);
        Charset charset = AbstractHttpClient.getContentCharSet(resp.getContentType());
        if (charset == null) {
            charset = Charset.defaultCharset();
            LOGGER.info("Can't find charset for name '{}'", (Object)resp.getContentEncoding());
        }
        try {
            try (InputStream content = resp.getContent();){
                String string = IOUtils.toString((InputStream)content, (Charset)charset);
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            resp.close();
        }
    }
}

