/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.ResponseData;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ResponseDataHandler
implements HttpResponseHandler<ResponseData> {
    @Override
    public ResponseData handleResponse(HttpResponse resp) throws IOException {
        ResponseData result = new ResponseData();
        try {
            this.transferHeader(result, resp);
            result.setResponseHttpCode(resp.getStatus());
            result.setResponse(this.readResponse(resp));
        }
        finally {
            resp.close();
        }
        return result;
    }

    private byte[] readResponse(HttpResponse resp) throws IOException {
        try (InputStream is = resp.getContent();){
            byte[] byArray = is != null ? IOUtils.toByteArray((InputStream)is) : new byte[]{};
            return byArray;
        }
    }

    private void transferHeader(ResponseData result, HttpResponse resp) {
        List<HttpHeader> header = resp.getHeader();
        result.setResponseHeader(this.mapHeader(header));
    }

    private Map<String, String> mapHeader(List<HttpHeader> header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (HttpHeader httpHeader : header) {
            result.put(httpHeader.getName(), httpHeader.getValue());
        }
        return result;
    }
}

