/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.ResponseData;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import de.governikus.csl.transport.exception.ConnectionException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

public interface HttpClient
extends Closeable {
    public void addDefaultHeader(String var1, String var2);

    public HttpResponse delete(URI var1, HttpHeader ... var2) throws ConnectionException;

    public <T> T post(URI var1, HttpRequest var2, HttpResponseHandler<T> var3, HttpHeader ... var4) throws IOException;

    public HttpResponse post(URI var1, HttpRequest var2, HttpHeader ... var3) throws ConnectionException;

    public <T> T put(URI var1, HttpRequest var2, HttpResponseHandler<T> var3, HttpHeader ... var4) throws IOException;

    public HttpResponse put(URI var1, HttpRequest var2, HttpHeader ... var3) throws ConnectionException;

    public <T> T get(URI var1, HttpResponseHandler<T> var2, HttpHeader ... var3) throws IOException;

    public HttpResponse get(URI var1, HttpHeader ... var2) throws ConnectionException;

    default public HttpResponse get(String uri, HttpHeader ... headers) throws ConnectionException {
        return this.get(URI.create(uri), headers);
    }

    default public HttpResponse delete(String uri, HttpHeader ... headers) throws ConnectionException {
        return this.delete(URI.create(uri), headers);
    }

    default public HttpResponse post(String uri, byte[] entity, HttpHeader ... headers) throws ConnectionException {
        return this.post(URI.create(uri), (HttpRequest)new ByteArrayRequest(entity), headers);
    }

    default public HttpResponse put(String uri, byte[] entity, HttpHeader ... headers) throws ConnectionException {
        return this.put(URI.create(uri), (HttpRequest)new ByteArrayRequest(entity), headers);
    }

    public ResponseData sendGETRequest(String var1) throws IOException;

    public ResponseData sendPOSTRequest(String var1) throws IOException;

    public ResponseData sendPOSTRequest(String var1, byte[] var2) throws IOException;

    public ResponseData sendGETRequest(String var1, Map<String, String> var2) throws IOException;

    public ResponseData sendPOSTRequest(String var1, Map<String, String> var2) throws IOException;

    public ResponseData sendPOSTRequest(String var1, Map<String, String> var2, byte[] var3) throws IOException;
}

