/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.exception.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    private HttpClient client;
    private boolean sendNoCacheHeader;
    private Map<String, String> ldapEnv;
    private static final Logger LOG = LoggerFactory.getLogger(Downloader.class);

    public Downloader(HttpClient client, boolean sendNoCacheHeader, Map<String, String> ldapEnv) {
        this.client = client;
        this.sendNoCacheHeader = sendNoCacheHeader;
        this.ldapEnv = ldapEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryFile(String url) throws IOException {
        HttpHeader[] headers = new HttpHeader[]{new HttpHeader("Cache-Control", "no-cache"), new HttpHeader("max-age", "0"), new HttpHeader("post-check", "0"), new HttpHeader("precheck", "0"), new HttpHeader("must-revalidate", ""), new HttpHeader("Pragma", "no-cache")};
        HttpResponse resp = null;
        try {
            resp = this.client.get(URI.create(url), headers);
            int status = resp.getStatus();
            if (status >= 300) {
                throw new ResponseException(status, resp.getStatusReason());
            }
            byte[] byArray = this.readResponse(resp);
            return byArray;
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    LOG.warn("Can't close http response", (Throwable)e);
                }
            }
        }
    }

    private byte[] readResponse(HttpResponse resp) throws IOException {
        try (InputStream is = resp.getContent();){
            byte[] byArray = is != null ? IOUtils.toByteArray((InputStream)is) : new byte[]{};
            return byArray;
        }
    }

    public byte[] sendLDAPRequestCRL(String ldapURL, Hashtable<String, String> env, String ... attributeList) throws NamingException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Loading CRL from URL: {}", (Object)ldapURL);
        }
        if (this.ldapEnv != null) {
            env.putAll(this.ldapEnv);
        }
        InitialDirContext ctx = new InitialDirContext(env);
        NamingEnumeration<SearchResult> answer = ctx.search(ldapURL, null);
        String[] attributeIDs = attributeList;
        if (attributeIDs == null || attributeIDs.length == 0) {
            attributeIDs = new String[]{"certificateRevocationList;binary"};
        }
        if (answer != null) {
            while (answer.hasMoreElements()) {
                SearchResult o;
                SearchResult sr = o = answer.next();
                Attributes attributes = sr.getAttributes();
                for (String attributeID : attributeIDs) {
                    Object value;
                    Attribute attribute = attributes.get(attributeID);
                    if (attribute == null && !attributeID.endsWith(";binary")) {
                        attribute = attributes.get(attributeID + ";binary");
                    }
                    if (attribute == null || !((value = attribute.get()) instanceof byte[])) continue;
                    return (byte[])value;
                }
            }
        }
        return null;
    }

    public byte[] sendHTTPRequest(String url, byte[] request) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>();
        if (this.sendNoCacheHeader) {
            header.put("Cache-Control", "no-cache");
            header.put("max-age", "0");
            header.put("post-check", "0");
            header.put("precheck", "0");
            header.put("must-revalidate", "");
            header.put("Pragma", "no-cache");
        }
        header.put("Accept", "application/ocsp-response");
        header.put("Content-Type", "application/ocsp-request");
        return this.sendHTTPRequest(url, request, header);
    }

    public byte[] sendHTTPRequest(String url, byte[] request, Map<String, String> header) throws IOException {
        return this.client.sendPOSTRequest(url, header, request).getResponse();
    }
}

