/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport;

import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.ResponseData;
import de.governikus.csl.transport.ResponseDataHandler;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import de.governikus.csl.transport.exception.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public abstract class AbstractHttpClient
implements HttpClient {
    private static final String HTTP_RESPONSE_CONTENT_TYPE_CHARSET_INFO = "charset";
    private static final String DEFAULT_TRUSTMANAGER_ALGORITHM = System.getProperty("ssl.trustManagerFactory.algorithm");
    protected Map<String, String> defaultHeader;

    @Override
    public void addDefaultHeader(String name, String value) {
        if (this.defaultHeader == null) {
            this.defaultHeader = new HashMap<String, String>();
        }
        this.defaultHeader.put(name, value);
    }

    @Override
    public <T> T get(URI uri, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        try (HttpResponse response = this.get(uri, headers);){
            T t = handler.handleResponse(response);
            return t;
        }
    }

    @Override
    public <T> T post(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        try (HttpResponse response = this.post(uri, entity, headers);){
            T t = handler.handleResponse(response);
            return t;
        }
    }

    @Override
    public <T> T put(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        try (HttpResponse response = this.put(uri, entity, headers);){
            T t = handler.handleResponse(response);
            return t;
        }
    }

    @Override
    public ResponseData sendGETRequest(String url) throws IOException {
        return this.get(URI.create(url), new ResponseDataHandler(), new HttpHeader[0]);
    }

    @Override
    public ResponseData sendPOSTRequest(String url) throws IOException {
        return this.post(URI.create(url), null, new ResponseDataHandler(), new HttpHeader[0]);
    }

    @Override
    public ResponseData sendGETRequest(String url, Map<String, String> header) throws IOException {
        HttpHeader[] h = this.convertHeaders(header);
        return this.get(URI.create(url), new ResponseDataHandler(), h);
    }

    @Override
    public ResponseData sendPOSTRequest(String url, Map<String, String> header) throws IOException {
        HttpHeader[] h = this.convertHeaders(header);
        return this.post(URI.create(url), null, new ResponseDataHandler(), h);
    }

    @Override
    public ResponseData sendPOSTRequest(String url, byte[] request) throws IOException {
        return this.post(URI.create(url), (HttpRequest)new ByteArrayRequest(request), new ResponseDataHandler(), new HttpHeader[0]);
    }

    @Override
    public ResponseData sendPOSTRequest(String url, Map<String, String> header, byte[] request) throws IOException {
        HttpHeader[] h = this.convertHeaders(header);
        return this.post(URI.create(url), (HttpRequest)new ByteArrayRequest(request), new ResponseDataHandler(), h);
    }

    private HttpHeader[] convertHeaders(Map<String, String> header) {
        if (header == null) {
            return new HttpHeader[0];
        }
        HttpHeader[] res = new HttpHeader[header.size()];
        int ptr = 0;
        for (Map.Entry<String, String> entry : header.entrySet()) {
            res[ptr++] = new HttpHeader(entry.getKey(), entry.getValue());
        }
        return res;
    }

    public static void checkResponseErrors(HttpResponse resp) throws IOException {
        int status = resp.getStatus();
        if (status >= 300) {
            String statusReason = resp.getStatusReason();
            String contentType = resp.getContentType();
            if (contentType != null && !contentType.isEmpty() && contentType.contains("text/plain")) {
                boolean isResponseContentAbsent;
                Charset charSet = AbstractHttpClient.getContentCharSet(contentType);
                String responseContent = null;
                try (InputStream is2 = resp.getContent();){
                    responseContent = IOUtils.toString((InputStream)is2, (Charset)charSet);
                }
                catch (IOException is2) {
                    // empty catch block
                }
                boolean isStatusReasonAbsent = statusReason == null || statusReason.isEmpty();
                boolean bl = isResponseContentAbsent = responseContent == null || responseContent.isEmpty();
                if (isStatusReasonAbsent && isResponseContentAbsent) {
                    statusReason = "unknown reason";
                } else if (!isStatusReasonAbsent && !isResponseContentAbsent) {
                    statusReason = statusReason + " " + responseContent;
                } else if (isStatusReasonAbsent) {
                    statusReason = responseContent;
                }
            } else {
                resp.consumeContentQuietly();
            }
            try {
                resp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ResponseException(status, statusReason);
        }
    }

    public static void checkResponseErrors(HttpURLConnection con) throws IOException {
        int status = con.getResponseCode();
        if (status >= 300) {
            String statusReason = con.getResponseMessage();
            String contentType = AbstractHttpClient.getContentType(con);
            if (contentType != null && !contentType.isEmpty() && contentType.contains("text/plain")) {
                boolean isResponseContentAbsent;
                Charset charSet = AbstractHttpClient.getContentCharSet(contentType);
                String responseContent = null;
                try (InputStream is2 = con.getInputStream();){
                    responseContent = IOUtils.toString((InputStream)is2, (Charset)charSet);
                }
                catch (IOException is2) {
                    // empty catch block
                }
                boolean isStatusReasonAbsent = statusReason == null || statusReason.isEmpty();
                boolean bl = isResponseContentAbsent = responseContent == null || responseContent.isEmpty();
                if (isStatusReasonAbsent && isResponseContentAbsent) {
                    statusReason = "unknown reason";
                } else if (!isStatusReasonAbsent && !isResponseContentAbsent) {
                    statusReason = statusReason + " " + responseContent;
                } else if (isStatusReasonAbsent) {
                    statusReason = responseContent;
                }
            } else {
                try (InputStream is = con.getInputStream();
                     NullOutputStream os = new NullOutputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                con.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(status + ": " + statusReason);
        }
    }

    public static String getContentType(HttpURLConnection con) {
        Map<String, List<String>> headerFields = con.getHeaderFields();
        if (headerFields != null && !headerFields.isEmpty()) {
            for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
                String key = header.getKey();
                List<String> value = header.getValue();
                if (!"Content-Type".equals(key) || value == null || value.isEmpty()) continue;
                return value.toString().replaceAll(Pattern.quote("["), "").replaceAll(Pattern.quote("]"), "").replaceAll(Pattern.quote(", "), "; ");
            }
        }
        return null;
    }

    public static Charset getContentCharSet(String contentType) {
        Charset charset = null;
        String contentCharset = null;
        if (contentType != null && contentType.contains(HTTP_RESPONSE_CONTENT_TYPE_CHARSET_INFO)) {
            int sidx = contentType.indexOf(HTTP_RESPONSE_CONTENT_TYPE_CHARSET_INFO) + HTTP_RESPONSE_CONTENT_TYPE_CHARSET_INFO.length() + 1;
            int eidx = contentType.indexOf(59, sidx);
            if (eidx == -1) {
                eidx = contentType.length();
            }
            contentCharset = contentType.substring(sidx, eidx);
        }
        if (contentCharset != null && !contentCharset.isEmpty()) {
            try {
                charset = Charset.forName(contentCharset);
            }
            catch (Exception exception) {}
        } else {
            charset = Charset.defaultCharset();
        }
        return charset;
    }
}

