/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.governikus.csl.request.ValidationDataImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.xaip.POECache;
import de.governikus.csl.xaip.XAIPContainer;
import de.governikus.csl.xaip.XAIPValidationDataSet;
import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class XAIPValidationDataResolver {
    private XAIPContainer container;
    private POECache poes;

    public XAIPValidationDataResolver(XAIPContainer container, POECache poeCache) {
        this.container = container;
        this.poes = poeCache;
    }

    public ValidationData getValidationData(Object referencedObject) {
        ValidationDataImpl result = null;
        List<SignatureValidationDataAttachment<X509Certificate>> certificates = this.getValidationDataForCertificatesCertificates(referencedObject);
        List<SignatureValidationDataAttachment<OCSPResp>> oCSPValues = this.getValidationDataForOCSPs(referencedObject);
        List<SignatureValidationDataAttachment<CRL>> cRLs = this.getValidationDataForCRLs(referencedObject);
        List<TypedDate> poeList = this.poes.getPOEs(referencedObject);
        if (certificates != null || oCSPValues != null || cRLs != null || poeList != null) {
            result = new ValidationDataImpl(InformationSource.REQUEST);
            result.setCertificates(certificates);
            result.setCRLs(cRLs);
            result.setOCSPValues(oCSPValues);
            result.setDocumentPOEs(poeList);
        }
        return result;
    }

    private List<SignatureValidationDataAttachment<CRL>> getValidationDataForCRLs(Object referencedObject) {
        return this.searchInList(this.container.getAttachedCRLs(), referencedObject);
    }

    private List<SignatureValidationDataAttachment<OCSPResp>> getValidationDataForOCSPs(Object referencedObject) {
        return this.searchInList(this.container.getAttachedOCSPs(), referencedObject);
    }

    private List<SignatureValidationDataAttachment<X509Certificate>> getValidationDataForCertificatesCertificates(Object referencedObject) {
        return this.searchInList(this.container.getAttachedCertificates(), referencedObject);
    }

    private boolean isInNullableList(List<Object> nullableList, Object objectToFind) {
        if (nullableList == null) {
            return false;
        }
        return nullableList.contains(objectToFind);
    }

    private <T> List<SignatureValidationDataAttachment<T>> searchInList(List<XAIPValidationDataSet<T>> validationData, Object referencedObject) {
        if (validationData == null || validationData.isEmpty()) {
            return Collections.emptyList();
        }
        return validationData.stream().filter(x -> this.isInNullableList(x.getCredential().getRelatedObjects(), referencedObject)).map(XAIPValidationDataSet::getValidationData).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

