/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.bund.bsi.tr_esor.xaip._1.CredentialType;
import de.bund.bsi.tr_esor.xaip._1.DataObjectType;
import de.bund.bsi.tr_esor.xaip._1.MetaDataObjectType;
import de.bund.bsi.tr_esor.xaip._1.VersionManifestType;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.xaip.DataHandlerDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XAIPProtectedDataSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAIPProtectedDataSerializer.class);

    public List<StreamProvider> serializeProtectedData(List<JAXBElement<Object>> protectedData, String canonAlgo, Binder<Node> binder) throws InvalidCanonicalizerException {
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)canonAlgo);
        ArrayList<StreamProvider> result = new ArrayList<StreamProvider>();
        for (JAXBElement<Object> p : protectedData) {
            Node element = null;
            String id = null;
            Object value = p.getValue();
            if (value instanceof DataObjectType) {
                DataObjectType data = (DataObjectType)value;
                DataObjectType.BinaryData binaryData = data.getBinaryData();
                if (binaryData == null) continue;
                result.add((StreamProvider)new DataHandlerDocument(binaryData.getValue(), data.getDataObjectID()));
                continue;
            }
            if (value instanceof MetaDataObjectType) {
                element = (Node)binder.getXMLNode(value);
                this.removeWhitespaces(element);
                id = ((MetaDataObjectType)value).getMetaDataID();
            } else if (value instanceof CredentialType) {
                element = (Node)binder.getXMLNode(value);
                this.removeWhitespaces(element);
                id = ((CredentialType)value).getCredentialID();
            } else if (value instanceof VersionManifestType) {
                VersionManifestType version = (VersionManifestType)value;
                element = (Node)binder.getXMLNode(value);
                this.removeWhitespaces(element);
                id = version.getVersionID();
            }
            if (element == null) continue;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    canonicalizer.canonicalizeSubtree(element, (OutputStream)baos);
                    byte[] data = baos.toByteArray();
                    result.add((StreamProvider)new ByteArrayDocument(data, id));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (baos == null) continue;
                    if (throwable != null) {
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    baos.close();
                }
            }
            catch (CanonicalizationException e) {
                LOGGER.info("Can't canonicalize referenced object", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Can not open output stream", (Throwable)e);
            }
        }
        return result;
    }

    private void removeWhitespaces(Node n) {
        NodeList childNodes = n.getChildNodes();
        if (childNodes != null) {
            int length = childNodes.getLength();
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            for (int i = 0; i < length; ++i) {
                Node child = childNodes.item(i);
                if (this.isWhitespace(child)) {
                    nodesToRemove.add(child);
                    continue;
                }
                this.removeWhitespaces(child);
            }
            for (Node nodeToRemove : nodesToRemove) {
                n.removeChild(nodeToRemove);
            }
        }
    }

    private boolean isWhitespace(Node child) {
        short nodeType = child.getNodeType();
        if (nodeType == 3) {
            Text text = (Text)child;
            String textContent = text.getTextContent();
            return textContent == null || textContent.trim().isEmpty();
        }
        return nodeType == 8;
    }
}

