/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.xaip.DefaultXAIPValidationFactory;
import de.governikus.csl.xaip.XAIPContainer;
import de.governikus.csl.xaip.XAIPContainerValidator;
import de.governikus.csl.xaip.XAIPParser;
import de.governikus.csl.xaip.XAIPValidationFactory;
import org.apache.xml.security.Init;

@PluginType(id=Plugin.PluginID.VALIDATE_XAIP, type=ValidatePlugin.class)
public class XAIPPlugin
implements ValidatePlugin {
    private Configuration configuration;
    private long priority = 1000L;
    private XAIPValidationFactory factory;

    public XAIPPlugin() {
        this(new DefaultXAIPValidationFactory());
    }

    public XAIPPlugin(XAIPValidationFactory factory) {
        this.factory = factory;
        Init.init();
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_XML;
    }

    public ObjectValidator getObjectValidator(SignedData doc, TempDataManager tempDataManager, IncludedFileValidator requestProcessor) throws ValidatePluginException {
        XAIPParser parser = this.factory.createParser(this.configuration.getAlgorithmManager());
        try {
            XAIPContainer container = parser.loadDocument(doc);
            if (container == null) {
                throw new ValidatePluginException((ValidatePlugin)this, "Can't parse XAIP container");
            }
            return new XAIPContainerValidator(container, requestProcessor, this.configuration, this.factory);
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse XAIP container", (Throwable)e);
        }
    }

    public boolean supportsMimeType(String mimetype) {
        if (mimetype == null) {
            return false;
        }
        return mimetype.equalsIgnoreCase("text/xml") || mimetype.equalsIgnoreCase("application/xml");
    }

    public String[] getSupportedFileExtensions() {
        return new String[]{"xml"};
    }

    public void configure(Configuration config) {
        this.configuration = config;
    }

    public SignatureValidator<?, ?, ?> createSignatureValidator(Signature signature, SignatureValidationContext context) {
        return null;
    }

    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long value) {
        this.priority = value;
    }

    public void initialize(InstanceProvider instanceProvider) throws Exception {
    }

    public String getID() {
        return Plugin.PluginID.VALIDATE_XAIP.getID();
    }
}

