/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.bos_bremen.ci.asn1.ParseException;
import de.bund.bsi.tr_esor.xaip._1.CredentialType;
import de.bund.bsi.tr_esor.xaip._1.CredentialsSectionType;
import de.bund.bsi.tr_esor.xaip._1.DataObjectType;
import de.bund.bsi.tr_esor.xaip._1.DataObjectsSectionType;
import de.bund.bsi.tr_esor.xaip._1.EvidenceRecordType;
import de.bund.bsi.tr_esor.xaip._1.ObjectFactory;
import de.bund.bsi.tr_esor.xaip._1.PackageHeaderType;
import de.bund.bsi.tr_esor.xaip._1.PackageInfoUnitType;
import de.bund.bsi.tr_esor.xaip._1.VersionManifestType;
import de.bund.bsi.tr_esor.xaip._1.XAIPType;
import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.er.EvidenceRecord;
import de.governikus.csl.validation.er.EvidenceRecordCreator;
import de.governikus.csl.xaip.XAIPContainer;
import de.governikus.csl.xaip.XAIPEvidenceRecord;
import de.governikus.csl.xaip.XAIPProtectedDataSerializer;
import de.governikus.csl.xaip.XAIPSignatureEntry;
import de.governikus.csl.xaip.XAIPValidationDataSet;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oasis.names.tc.dss._1_0.core.schema.Base64Signature;
import oasis.names.tc.dss._1_0.core.schema.SignatureObject;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.x509.util.StreamParsingException;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.CertificateValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.CanonicalizationMethodType;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class XAIPParser
extends AbstractDocumentParser<XAIPContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAIPParser.class);
    private AlgorithmManager algorithmManager;
    private Binder<Node> binder;
    private static JAXBContext context;
    private static DocumentBuilderFactory dbf;

    public XAIPParser(AlgorithmManager algorithmManager) {
        this.algorithmManager = algorithmManager;
    }

    public XAIPContainer loadDocument(SignedData sda) throws Exception {
        if (context == null) {
            return null;
        }
        Document signature = sda.getSignature();
        try (InputStream is = signature.getInputStream();){
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            org.w3c.dom.Document document = documentBuilder.parse(is);
            this.binder = context.createBinder();
            Object object = this.binder.unmarshal((Object)document);
            if (object instanceof JAXBElement) {
                JAXBElement jaxbElem = (JAXBElement)object;
                object = jaxbElem.getValue();
            }
            if (object instanceof XAIPType) {
                XAIPContainer result = this.processXAIP((XAIPType)object);
                result.setName(signature.getName());
                XAIPContainer xAIPContainer = result;
                return xAIPContainer;
            }
        }
        return null;
    }

    private XAIPContainer processXAIP(XAIPType xaip) {
        DataObjectsSectionType dataObjectsSection = xaip.getDataObjectsSection();
        XAIPContainer result = new XAIPContainer();
        this.parseValidationData(xaip, result);
        this.parseDataObjects(dataObjectsSection, result);
        this.parseSignatures(xaip, result);
        this.parseEvidenceRecords(xaip, result);
        return result;
    }

    private void parseSignatures(XAIPType xaip, XAIPContainer result) {
        CredentialsSectionType credentialsSection = xaip.getCredentialsSection();
        if (credentialsSection == null) {
            return;
        }
        List credential = credentialsSection.getCredential();
        for (CredentialType cred : credential) {
            Base64Signature base64Signature;
            SignatureObject signatureObject = cred.getSignatureObject();
            if (signatureObject == null || (base64Signature = signatureObject.getBase64Signature()) == null) continue;
            result.addSignature(new XAIPSignatureEntry(base64Signature.getValue(), cred));
        }
    }

    private void parseDataObjects(DataObjectsSectionType dataObjectsSection, XAIPContainer result) {
        if (dataObjectsSection == null) {
            return;
        }
        List dataObject = dataObjectsSection.getDataObject();
        for (DataObjectType dot : dataObject) {
            DataObjectType.BinaryData binaryData = dot.getBinaryData();
            if (binaryData == null) continue;
            result.addDataObject(dot);
        }
    }

    private void parseValidationData(XAIPType xaip, XAIPContainer result) {
        CredentialsSectionType credentialsSection = xaip.getCredentialsSection();
        if (credentialsSection == null) {
            return;
        }
        List credential = credentialsSection.getCredential();
        for (CredentialType cred : credential) {
            RevocationValuesType revocationValues;
            CertificateValuesType certificateValues = cred.getCertificateValues();
            if (certificateValues != null) {
                this.parseCertificates(certificateValues, result, cred);
            }
            if ((revocationValues = cred.getRevocationValues()) == null) continue;
            this.parseRevocationValues(revocationValues, result, cred);
        }
    }

    private void parseRevocationValues(RevocationValuesType revocationValues, XAIPContainer result, CredentialType cred) {
        OCSPValuesType ocspValues;
        CRLValuesType crlValues = revocationValues.getCRLValues();
        if (crlValues != null) {
            this.parseCRLValues(crlValues, result, cred);
        }
        if ((ocspValues = revocationValues.getOCSPValues()) != null) {
            this.parseOCSPValues(ocspValues, result, cred);
        }
    }

    private void parseOCSPValues(OCSPValuesType ocspValues, XAIPContainer result, CredentialType credential) {
        XAIPValidationDataSet<OCSPResp> res = new XAIPValidationDataSet<OCSPResp>(credential);
        List encapsulatedOCSPValue = ocspValues.getEncapsulatedOCSPValue();
        for (EncapsulatedPKIDataType ocsp : encapsulatedOCSPValue) {
            byte[] value = ocsp.getValue();
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(value);
                Throwable throwable = null;
                try {
                    res.add((SignatureValidationDataAttachmentImpl<OCSPResp>)new SignatureValidationDataAttachmentImpl((Object)new OCSPResp((InputStream)is)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                LOGGER.info("Can't parse OCSP", (Throwable)e);
            }
        }
        result.addOCSPs(res);
    }

    private void parseCRLValues(CRLValuesType crlValues, XAIPContainer result, CredentialType credential) {
        XAIPValidationDataSet<CRL> res = new XAIPValidationDataSet<CRL>(credential);
        List encapsulatedCRLValue = crlValues.getEncapsulatedCRLValue();
        for (EncapsulatedPKIDataType crl : encapsulatedCRLValue) {
            byte[] value = crl.getValue();
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(value);
                Throwable throwable = null;
                try {
                    X509CRLParser parser = new X509CRLParser();
                    parser.engineInit((InputStream)is);
                    res.add((SignatureValidationDataAttachmentImpl<CRL>)new SignatureValidationDataAttachmentImpl((Object)((X509CRL)parser.engineRead())));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | StreamParsingException e) {
                LOGGER.info("Can't parse CRL", e);
            }
        }
        result.addCRLs(res);
    }

    private void parseCertificates(CertificateValuesType certificateValues, XAIPContainer result, CredentialType cred) {
        XAIPValidationDataSet<X509Certificate> res = new XAIPValidationDataSet<X509Certificate>(cred);
        List encapsulatedX509CertificateOrOtherCertificate = certificateValues.getEncapsulatedX509CertificateOrOtherCertificate();
        for (Object o : encapsulatedX509CertificateOrOtherCertificate) {
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            if (!(o instanceof EncapsulatedPKIDataType)) continue;
            EncapsulatedPKIDataType pkiData = (EncapsulatedPKIDataType)o;
            byte[] value = pkiData.getValue();
            try {
                X509Certificate cert = CryptoProviderUtil.loadCert((byte[])value);
                res.add((SignatureValidationDataAttachmentImpl<X509Certificate>)new SignatureValidationDataAttachmentImpl((Object)cert));
            }
            catch (IOException | NoSuchProviderException | CertificateException e) {
                LOGGER.info("Can't parse certificate", (Throwable)e);
            }
        }
        result.addCertificates(res);
    }

    private void parseEvidenceRecords(XAIPType xaip, XAIPContainer result) {
        CredentialsSectionType credentialsSection = xaip.getCredentialsSection();
        if (credentialsSection == null) {
            return;
        }
        List credential = credentialsSection.getCredential();
        ArrayList<XAIPEvidenceRecord> ers = null;
        for (CredentialType cred : credential) {
            XAIPEvidenceRecord er;
            EvidenceRecordType evidenceRecord = cred.getEvidenceRecord();
            if (evidenceRecord == null || (er = this.parseEvidenceRecord(evidenceRecord, cred, xaip)) == null) continue;
            if (ers == null) {
                ers = new ArrayList<XAIPEvidenceRecord>();
                result.setEvidenceRecords(ers);
            }
            ers.add(er);
        }
    }

    private XAIPEvidenceRecord parseEvidenceRecord(EvidenceRecordType evidenceRecord, CredentialType cred, XAIPType xaip) {
        byte[] asn1EvidenceRecord = evidenceRecord.getAsn1EvidenceRecord();
        EvidenceRecordCreator erCreator = new EvidenceRecordCreator(this.algorithmManager);
        try {
            EvidenceRecord er = erCreator.create(asn1EvidenceRecord);
            XAIPEvidenceRecord xaipER = new XAIPEvidenceRecord(cred, er);
            this.addProtectedData(xaipER, cred.getRelatedObjects(), evidenceRecord.getVersionID(), xaip);
            return xaipER;
        }
        catch (ParseException e) {
            LOGGER.warn("Can't parse evidence record");
            return null;
        }
    }

    private void addProtectedData(XAIPEvidenceRecord xaipER, List<Object> relatedObjects, String versionID, XAIPType xaip) {
        PackageHeaderType packageHeader = xaip.getPackageHeader();
        if (packageHeader == null) {
            return;
        }
        List<JAXBElement<Object>> protectedData = this.getProtectedData(relatedObjects, versionID, xaip);
        if (protectedData == null) {
            return;
        }
        xaipER.setProtectedObjects(protectedData.stream().map(JAXBElement::getValue).collect(Collectors.toList()));
        String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
        CanonicalizationMethodType canonicalizationMethod = packageHeader.getCanonicalizationMethod();
        if (canonicalizationMethod != null) {
            canonAlgo = canonicalizationMethod.getAlgorithm();
        }
        try {
            xaipER.getEvidenceRecord().setExpectedSecuredData(new XAIPProtectedDataSerializer().serializeProtectedData(protectedData, canonAlgo, this.binder));
        }
        catch (InvalidCanonicalizerException e) {
            LOGGER.info("Invalid canonicalization algorithm found in package header", (Throwable)e);
        }
    }

    private List<JAXBElement<Object>> getProtectedData(List<Object> relatedObjects, String versionID, XAIPType xaip) {
        PackageHeaderType packageHeader = xaip.getPackageHeader();
        if (packageHeader == null) {
            return null;
        }
        List versionManifest = packageHeader.getVersionManifest();
        return versionManifest.stream().filter(x -> this.isVersionManifestReferenced((VersionManifestType)x, relatedObjects, versionID)).map(VersionManifestType::getPackageInfoUnit).flatMap(Collection::stream).map(PackageInfoUnitType::getProtectedObjectPointer).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isVersionManifestReferenced(VersionManifestType versionManifest, List<Object> relatedObjects, String versionID) {
        if (versionID != null) {
            return versionManifest.getVersionID().equals(versionID);
        }
        if (relatedObjects != null) {
            return relatedObjects.contains(versionManifest);
        }
        return false;
    }

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(true);
        }
        catch (JAXBException e) {
            LOGGER.error("Can't get JAXBContext. XAIP-Containers won't be validated", (Throwable)e);
        }
    }
}

