/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.bund.bsi.tr_esor.xaip._1.CredentialType;
import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.xaip.POECache;
import de.governikus.csl.xaip.XAIPContainer;
import de.governikus.csl.xaip.XAIPValidateContext;
import de.governikus.csl.xaip.XAIPValidationDataSet;
import java.util.List;

public class XAIPPOEPublisher {
    public void publishPOEsToValidationData(XAIPValidateContext ctx) {
        POECache poeCache = ctx.getPoeCache();
        if (poeCache.isEmpty()) {
            return;
        }
        XAIPContainer container = ctx.getContainer();
        this.publishPOEsToValidationData(poeCache, container.getAttachedCertificates());
        this.publishPOEsToValidationData(poeCache, container.getAttachedCRLs());
        this.publishPOEsToValidationData(poeCache, container.getAttachedOCSPs());
    }

    private void publishPOEsToValidationData(POECache poeCache, List<? extends XAIPValidationDataSet<?>> validationData) {
        if (validationData == null) {
            return;
        }
        for (XAIPValidationDataSet<?> valData : validationData) {
            CredentialType credential = valData.getCredential();
            List<TypedDate> poes = poeCache.getPOEs(credential);
            if (poes == null) continue;
            List<SignatureValidationDataAttachmentImpl<?>> vd = valData.getValidationData();
            for (SignatureValidationDataAttachmentImpl<?> attachment : vd) {
                attachment.addPOEs(poes);
            }
        }
    }
}

