/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.bund.bsi.tr_esor.xaip._1.DataObjectType;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.XAIPContainerValidationResult;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.xaip.DataHandlerDocument;
import de.governikus.csl.xaip.XAIPContainer;
import de.governikus.csl.xaip.XAIPSignatureEntry;
import de.governikus.csl.xaip.XAIPValidateContext;
import de.governikus.csl.xaip.XAIPValidationDataResolver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAIPIncludedFileValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAIPIncludedFileValidator.class);
    private IncludedFileValidator requestProcessor;

    public XAIPIncludedFileValidator(IncludedFileValidator requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    public void validateIncludedFiles(XAIPValidateContext ctx) {
        List<DataObjectType> dataObjects = ctx.getContainer().getDataObjects();
        ArrayList<DataObjectType> dataObjectsToValidate = null;
        if (dataObjects != null) {
            dataObjectsToValidate = new ArrayList<DataObjectType>(dataObjects);
        }
        this.validateSignatures(ctx, dataObjectsToValidate);
        this.validateRemainingDataObjects(ctx, dataObjectsToValidate);
    }

    private void validateSignatures(XAIPValidateContext ctx, List<DataObjectType> dataObjectsToValidate) {
        XAIPContainer container = ctx.getContainer();
        XAIPContainerValidationResult result = ctx.getResult();
        List<XAIPSignatureEntry> signatureDocuments = container.getSignatureDocuments();
        if (signatureDocuments == null) {
            return;
        }
        List includedFilesValidationResults = result.getIncludedFileValidationResults();
        for (XAIPSignatureEntry doc : signatureDocuments) {
            DataHandlerDocument sig = new DataHandlerDocument(doc.getSignature(), doc.getCredential().getCredentialID());
            List<Document> contents = this.getContents(doc, dataObjectsToValidate);
            ValidationData validationData = new XAIPValidationDataResolver(container, ctx.getPoeCache()).getValidationData(doc.getCredential());
            ValidationOptions options = ctx.getDocumentValidationContext().getOptions();
            options.setValidationData(validationData);
            this.validate(options, includedFilesValidationResults, sig, contents, ctx);
        }
    }

    private void validateRemainingDataObjects(XAIPValidateContext ctx, List<DataObjectType> dataObjectsToValidate) {
        if (dataObjectsToValidate == null || dataObjectsToValidate.isEmpty()) {
            return;
        }
        ValidationOptions options = ctx.getDocumentValidationContext().getOptions();
        XAIPContainerValidationResult result = ctx.getResult();
        List includedFilesValidationResults = result.getIncludedFileValidationResults();
        for (DataObjectType dataObject : dataObjectsToValidate) {
            DataObjectType.BinaryData binaryData = dataObject.getBinaryData();
            if (binaryData == null) continue;
            LOGGER.debug("Validating data object {}", (Object)dataObject.getDataObjectID());
            ValidationData validationData = new XAIPValidationDataResolver(ctx.getContainer(), ctx.getPoeCache()).getValidationData(dataObject);
            options.setValidationData(validationData);
            this.validate(options, includedFilesValidationResults, new DataHandlerDocument(binaryData.getValue(), dataObject.getDataObjectID()), null, ctx);
        }
    }

    private List<Document> getContents(XAIPSignatureEntry signature, List<DataObjectType> dataObjectsToValidate) {
        List<Object> relatedObjects = signature.getRelatedObjects();
        if (relatedObjects == null || relatedObjects.isEmpty() || dataObjectsToValidate == null || dataObjectsToValidate.isEmpty()) {
            return null;
        }
        ArrayList<DataHandlerDocument> res = null;
        for (Object rel : relatedObjects) {
            Iterator<DataObjectType> iterator = dataObjectsToValidate.iterator();
            while (iterator.hasNext()) {
                DataObjectType data = iterator.next();
                if (!rel.equals(data)) continue;
                if (res == null) {
                    res = new ArrayList<DataHandlerDocument>();
                }
                res.add(new DataHandlerDocument(data.getBinaryData().getValue(), data.getDataObjectID()));
                iterator.remove();
            }
        }
        return res;
    }

    private void validate(ValidationOptions options, List<ObjectValidationResult> includedFilesValidationResults, Document signature, List<Document> contents, XAIPValidateContext ctx) {
        DocumentValidationContext context = new DocumentValidationContext();
        context.setOptions(options);
        context.setPolicyManager(ctx.getPolicyManager());
        context.setIncludedFileRecursionLevel(1);
        ObjectValidationResult contentFileValidationResult = null;
        try {
            SimpleSignedData sda = null;
            sda = contents == null ? new SimpleSignedData(signature) : new SimpleSignedData(contents, signature);
            contentFileValidationResult = this.requestProcessor.validate((SignedData)sda, context);
        }
        catch (CoreException e) {
            LOGGER.debug("Can't validate content file");
        }
        if (contentFileValidationResult == null) {
            contentFileValidationResult = SVPFactory.createObjectValidationResult((String)"UNKNOWN");
            contentFileValidationResult.setObjectName(signature.getName());
        }
        includedFilesValidationResults.add(contentFileValidationResult);
    }
}

