/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.validate.svp.EvidenceRecordValidationResult;
import de.governikus.csl.validate.svp.XAIPContainerValidationResult;
import de.governikus.csl.validation.er.EvidenceRecordResultUtil;
import de.governikus.csl.validation.er.EvidenceRecordValidator;
import de.governikus.csl.validation.er.TimestampTokenValidator;
import de.governikus.csl.xaip.POECache;
import de.governikus.csl.xaip.XAIPContainer;
import de.governikus.csl.xaip.XAIPEvidenceRecord;
import de.governikus.csl.xaip.XAIPValidateContext;
import de.governikus.csl.xaip.XAIPValidationFactory;
import java.util.Date;
import java.util.List;

public class XAIPEvidenceRecordValidator {
    private XAIPValidationFactory factory;

    public XAIPEvidenceRecordValidator(XAIPValidationFactory factory) {
        this.factory = factory;
    }

    public void validateEvidenceRecords(XAIPValidateContext ctx) {
        XAIPContainer container = ctx.getContainer();
        POECache poeCache = ctx.getPoeCache();
        XAIPContainerValidationResult result = ctx.getResult();
        List<XAIPEvidenceRecord> evidenceRecords = container.getEvidenceRecords();
        if (evidenceRecords == null || evidenceRecords.isEmpty()) {
            return;
        }
        for (XAIPEvidenceRecord er : evidenceRecords) {
            ValidationData validationData = this.factory.createValidationDataResolver(ctx).getValidationData(er.getCredential());
            TimestampTokenValidator timestampValidator = this.factory.createTimestampTokenValidator(ctx.getDocumentValidationContext(), ctx.getConfiguration(), ctx.getPolicyManager(), validationData);
            EvidenceRecordValidator erValidator = this.factory.createCSLEvidenceRecordValidator(timestampValidator, ctx.getConfiguration().getAlgorithmCatalog());
            EvidenceRecordValidationResult validate = erValidator.validate(er.getEvidenceRecord(), new Date());
            result.getEvidenceRecordValidationResults().add(validate);
            List poes = EvidenceRecordResultUtil.getPOEsFromEvidenceRecordValidationResult((EvidenceRecordValidationResult)validate);
            if (poes == null || poes.isEmpty()) continue;
            poeCache.addPOEsForObjects(er.getProtectedObjects(), poes);
        }
    }
}

