/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.PolicyEvaluationState;
import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.BestPOEDeterminator;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.SignatureValidator;
import de.governikus.csl.validation.context.ContextUtil;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.er.ArchiveTimestampTokenValidationResult;
import de.governikus.csl.validation.er.TimestampTokenValidator;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.validation.policy.PolicyEvaluator;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.tsp.TSPPlugin;
import de.governikus.csl.validation.x509.chain.PolicyDeterminator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class XAIPEvidenceRecordTimestampValidator
implements TimestampTokenValidator {
    private DocumentValidationContext ctx;
    private Configuration config;
    private EvaluatingPolicyReferenceManager policyManager;
    private ValidationData validationData;

    public XAIPEvidenceRecordTimestampValidator(DocumentValidationContext ctx, Configuration config, EvaluatingPolicyReferenceManager policyManager, ValidationData validationData) {
        this.ctx = ctx;
        this.config = config;
        this.policyManager = policyManager;
        this.validationData = validationData;
    }

    public ArchiveTimestampTokenValidationResult validateTimestampToken(WritableTimestamp<?> tst, byte[] messageDigest, Date validationDate) {
        tst.setTimestampedContentHash(messageDigest);
        TSPPlugin tspPlugin = new TSPPlugin();
        EvaluatedValidationPolicyType evaluatedPolicy = this.getPolicyForTimestampValidation((Timestamp)tst);
        ValidationPolicyType policy = evaluatedPolicy.getPolicy();
        SignatureValidationContext context = tspPlugin.createContext(tst, policy);
        context.setDocumentValidationContext(this.ctx);
        context.setConfiguration(this.config);
        context.extendContext(tst, this.ctx.getOptions().getValidationDate(), (ValidatePolicy)policy);
        context.setBestSigningTime(BestPOEDeterminator.getBestPOE(null, (ValidatePolicy)policy));
        context.setBestAlgValidationTime(BestPOEDeterminator.getBestPOEForAlgorithmValidity(null, (ValidatePolicy)policy));
        if (this.validationData != null) {
            ContextUtil.extendContextWithCertificates((SignatureValidationContext)context, (Collection)this.validationData.getCertificates(), (InformationSource)this.validationData.getSource());
            ContextUtil.extendContextWithRevocationValues((SignatureValidationContext)context, (List)this.validationData.getOCSPValues(), (List)this.validationData.getCRLs(), (InformationSource)this.validationData.getSource());
        }
        SignatureValidator tstValidator = tspPlugin.createSignatureValidator(tst, context, TSPPlugin.getAllKnownCustomPlugins());
        TimestampValidationResult validateSignature = (TimestampValidationResult)tstValidator.validateSignature();
        int policyRef = this.policyManager.addPolicy(evaluatedPolicy);
        validateSignature.setPolicyReference(policyRef);
        return new ArchiveTimestampTokenValidationResult(validateSignature, policy);
    }

    private EvaluatedValidationPolicyType getPolicyForTimestampValidation(Timestamp tst) {
        PolicyProviderManager ppm = this.config.getPolicyProviderManager();
        return Optional.ofNullable(this.ctx).map(DocumentValidationContext::getOptions).map(ValidationOptions::getPolicy).map(x -> this.createEvaluatedPolicy((ValidationPolicyType)x, PolicyEvaluator.evaluatePolicy((ValidationPolicyType)x, (PolicyProviderManager)ppm), PolicyOrigin.REQUEST)).orElseGet(() -> this.createEvaluatedPolicy(new PolicyDeterminator(ppm).process(tst), PolicyEvaluationState.TRUSTED_POLICY, PolicyOrigin.AUTOMATIC_DETERMINATION));
    }

    private EvaluatedValidationPolicyType createEvaluatedPolicy(ValidationPolicyType policy, PolicyEvaluationState evaluationState, PolicyOrigin policyOrigin) {
        EvaluatedValidationPolicyType res = new EvaluatedValidationPolicyType();
        res.setPolicy(policy);
        res.setEvaluationState(evaluationState);
        res.setPolicyOrigin(policyOrigin);
        return res;
    }
}

