/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.XAIPContainerValidationResult;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.xaip.XAIPContainer;
import de.governikus.csl.xaip.XAIPValidateContext;
import de.governikus.csl.xaip.XAIPValidationFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAIPContainerValidator
implements ObjectValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAIPContainerValidator.class);
    private XAIPContainer container;
    private IncludedFileValidator requestProcessor;
    private Configuration config;
    private XAIPValidationFactory factory;

    public XAIPContainer getObjectToValidate() {
        return this.container;
    }

    public XAIPContainerValidator(XAIPContainer container, IncludedFileValidator requestProcessor, Configuration config, XAIPValidationFactory factory) {
        this.container = container;
        this.requestProcessor = requestProcessor;
        this.config = config;
        this.factory = factory;
    }

    public XAIPContainerValidationResult validate(DocumentValidationContext documentValidationContext) {
        List policyEntries;
        LOGGER.debug("Start validating xaip container {}", (Object)this.container.getName());
        EvaluatingPolicyReferenceManager policyManager = documentValidationContext.getPolicyManager();
        boolean includePoliciesInResult = false;
        if (policyManager == null) {
            policyManager = new EvaluatingPolicyReferenceManager(this.config.getPolicyProviderManager());
            documentValidationContext.setPolicyManager(policyManager);
            includePoliciesInResult = true;
        }
        XAIPValidateContext ctx = new XAIPValidateContext(this.container, documentValidationContext, this.config, policyManager);
        this.factory.createDocumentDataExtractor().extractData((ObjectToValidate)this.container, (ObjectValidationResult)ctx.getResult());
        this.factory.createEvidenceRecordValidator().validateEvidenceRecords(ctx);
        this.factory.createPOEPublisher().publishPOEsToValidationData(ctx);
        this.factory.createIncludedFilesValidator(this.requestProcessor).validateIncludedFiles(ctx);
        XAIPContainerValidationResult result = ctx.getResult();
        if (includePoliciesInResult && (policyEntries = policyManager.getPolicyEntries()) != null) {
            result.getPolicyEntries().addAll(policyEntries);
        }
        LOGGER.debug("Finished validating xaip container");
        return result;
    }
}

