/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.bund.bsi.tr_esor.xaip._1.DataObjectType;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.xaip.XAIPEvidenceRecord;
import de.governikus.csl.xaip.XAIPSignatureEntry;
import de.governikus.csl.xaip.XAIPValidationDataSet;
import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class XAIPContainer
implements ObjectToValidate<Signature> {
    private List<XAIPEvidenceRecord> evidenceRecords;
    private List<XAIPValidationDataSet<X509Certificate>> attachedCertificates;
    private List<XAIPValidationDataSet<CRL>> attachedCRLs;
    private List<XAIPValidationDataSet<OCSPResp>> attachedOCSPs;
    private List<DataObjectType> dataObjects;
    private List<XAIPSignatureEntry> signatureDocuments;
    private String name;
    private List<Document> includedFilesToValidate;

    public List<XAIPEvidenceRecord> getEvidenceRecords() {
        return this.evidenceRecords;
    }

    public void setEvidenceRecords(List<XAIPEvidenceRecord> evidenceRecords) {
        this.evidenceRecords = evidenceRecords;
    }

    public void addCertificates(XAIPValidationDataSet<X509Certificate> res) {
        if (this.attachedCertificates == null) {
            this.attachedCertificates = new ArrayList<XAIPValidationDataSet<X509Certificate>>();
        }
        this.attachedCertificates.add(res);
    }

    public void addCRLs(XAIPValidationDataSet<CRL> res) {
        if (this.attachedCRLs == null) {
            this.attachedCRLs = new ArrayList<XAIPValidationDataSet<CRL>>();
        }
        this.attachedCRLs.add(res);
    }

    public void addOCSPs(XAIPValidationDataSet<OCSPResp> res) {
        if (this.attachedOCSPs == null) {
            this.attachedOCSPs = new ArrayList<XAIPValidationDataSet<OCSPResp>>();
        }
        this.attachedOCSPs.add(res);
    }

    public void addDataObject(DataObjectType dot) {
        if (this.dataObjects == null) {
            this.dataObjects = new ArrayList<DataObjectType>();
        }
        this.dataObjects.add(dot);
    }

    public void addSignature(XAIPSignatureEntry xaipSignatureEntry) {
        if (this.signatureDocuments == null) {
            this.signatureDocuments = new ArrayList<XAIPSignatureEntry>();
        }
        this.signatureDocuments.add(xaipSignatureEntry);
    }

    public List<XAIPValidationDataSet<X509Certificate>> getAttachedCertificates() {
        return this.attachedCertificates;
    }

    public List<XAIPValidationDataSet<CRL>> getAttachedCRLs() {
        return this.attachedCRLs;
    }

    public List<XAIPValidationDataSet<OCSPResp>> getAttachedOCSPs() {
        return this.attachedOCSPs;
    }

    public List<DataObjectType> getDataObjects() {
        return this.dataObjects;
    }

    public List<XAIPSignatureEntry> getSignatureDocuments() {
        return this.signatureDocuments;
    }

    public List<? extends Signature> getSignatures() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Document> getIncludedFilesToValidate() {
        return this.includedFilesToValidate;
    }

    public void setIncludedFilesToValidate(List<Document> files) {
        this.includedFilesToValidate = files;
    }
}

