/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xaip;

import de.governikus.csl.algorithm_catalog.AlgorithmCatalogManager;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.ValidationData;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.dataExtractor.DefaultDocumentDataExtractor;
import de.governikus.csl.validation.er.ArchiveTimestampChainValidator;
import de.governikus.csl.validation.er.ArchiveTimestampValidator;
import de.governikus.csl.validation.er.EvidenceRecordValidator;
import de.governikus.csl.validation.er.ReducedHashTreeDigestAlgorithmValidator;
import de.governikus.csl.validation.er.ReducedHashTreeValidator;
import de.governikus.csl.validation.er.TimestampTokenValidator;
import de.governikus.csl.validation.policy.EvaluatingPolicyReferenceManager;
import de.governikus.csl.xaip.XAIPEvidenceRecordTimestampValidator;
import de.governikus.csl.xaip.XAIPEvidenceRecordValidator;
import de.governikus.csl.xaip.XAIPIncludedFileValidator;
import de.governikus.csl.xaip.XAIPPOEPublisher;
import de.governikus.csl.xaip.XAIPParser;
import de.governikus.csl.xaip.XAIPValidateContext;
import de.governikus.csl.xaip.XAIPValidationDataResolver;
import de.governikus.csl.xaip.XAIPValidationFactory;

public class DefaultXAIPValidationFactory
implements XAIPValidationFactory {
    @Override
    public TimestampTokenValidator createTimestampTokenValidator(DocumentValidationContext documentValidationContext, Configuration configuration, EvaluatingPolicyReferenceManager policyManager, ValidationData validationData) {
        return new XAIPEvidenceRecordTimestampValidator(documentValidationContext, configuration, policyManager, validationData);
    }

    @Override
    public XAIPEvidenceRecordValidator createEvidenceRecordValidator() {
        return new XAIPEvidenceRecordValidator(this);
    }

    @Override
    public XAIPValidationDataResolver createValidationDataResolver(XAIPValidateContext ctx) {
        return new XAIPValidationDataResolver(ctx.getContainer(), ctx.getPoeCache());
    }

    @Override
    public EvidenceRecordValidator createCSLEvidenceRecordValidator(TimestampTokenValidator timestampValidator, AlgorithmCatalogManager algorithmCatalog) {
        return new EvidenceRecordValidator(new ArchiveTimestampChainValidator(new ArchiveTimestampValidator(timestampValidator, new ReducedHashTreeValidator(), new ReducedHashTreeDigestAlgorithmValidator(algorithmCatalog))));
    }

    @Override
    public DefaultDocumentDataExtractor createDocumentDataExtractor() {
        return new DefaultDocumentDataExtractor();
    }

    @Override
    public XAIPPOEPublisher createPOEPublisher() {
        return new XAIPPOEPublisher();
    }

    @Override
    public XAIPIncludedFileValidator createIncludedFilesValidator(IncludedFileValidator requestProcessor) {
        return new XAIPIncludedFileValidator(requestProcessor);
    }

    @Override
    public XAIPParser createParser(AlgorithmManager algorithmManager) {
        return new XAIPParser(algorithmManager);
    }
}

