/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.utils.rest.client;

import java.net.URI;
import java.net.URISyntaxException;

public class URIBuilder {
    private URI uri;

    public URIBuilder(URI uri) {
        this.uri = uri;
    }

    public URIBuilder(String uri) {
        this.uri = URI.create(uri);
    }

    private URI buildURIFromComponents(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        try {
            return new URI(scheme, userInfo, host, port, path, query, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI can't be build", e);
        }
    }

    public URIBuilder path(String path) {
        Object pathToAppend = path.trim();
        boolean pathStartsWithSlash = ((String)pathToAppend).startsWith("/");
        String currentPath = this.uri.getPath();
        if (currentPath == null || currentPath.isEmpty()) {
            if (!pathStartsWithSlash) {
                pathToAppend = "/" + (String)pathToAppend;
            }
            this.uri = this.buildURIFromComponents(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), (String)pathToAppend, this.uri.getQuery(), this.uri.getFragment());
            return this;
        }
        boolean currentPathEndWithSlash = currentPath.endsWith("/");
        if (currentPathEndWithSlash) {
            if (pathStartsWithSlash) {
                pathToAppend = path.substring(1);
            }
        } else if (!pathStartsWithSlash) {
            pathToAppend = "/" + (String)pathToAppend;
        }
        this.uri = this.buildURIFromComponents(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), currentPath + (String)pathToAppend, this.uri.getQuery(), this.uri.getFragment());
        return this;
    }

    public URIBuilder query(String query) {
        String currentQuery = this.uri.getQuery();
        if (currentQuery != null && !currentQuery.isEmpty()) {
            query = currentQuery + "&" + (String)query;
        }
        this.uri = this.buildURIFromComponents(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), (String)query, this.uri.getFragment());
        return this;
    }

    public URI build() {
        return this.uri;
    }

    public URIBuilder clone() {
        return new URIBuilder(this.uri);
    }
}

