/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.utils.rest.client;

import de.governikus.csc.utils.rest.client.JSONBindingResponseHandler;
import de.governikus.csc.utils.rest.client.JSONEntity;
import de.governikus.csc.utils.rest.client.ResponseHeaderListener;
import de.governikus.csc.utils.rest.client.SimpleRESTClient;
import de.governikus.csc.utils.rest.client.URIBuilder;
import de.governikus.csl.transport.AbstractHttpClient;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseStream;
import de.governikus.csl.transport.entity.InputStreamRequest;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.docs.StreamDocument;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServiceClient<I, O>
extends SimpleRESTClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleServiceClient.class);
    private URIBuilder baseUriBuilder;
    private final List<ResponseHeaderListener> responseHeaderListeners = new LinkedList<ResponseHeaderListener>();
    private Class<O> outputClass;

    public SimpleServiceClient(URI baseURI, HttpClient client, Class<O> outputClass) {
        super(client);
        this.baseUriBuilder = new URIBuilder(baseURI);
        this.outputClass = outputClass;
    }

    public Document handleProfile(Document document, String profileID) throws IOException {
        Object path = "handle/";
        if (profileID != null) {
            path = (String)path + profileID;
        }
        URI uri = this.baseUriBuilder.clone().path((String)path).build();
        try (InputStream is = document.getInputStream();){
            HttpResponse httpResponse = this.client.put(uri, (HttpRequest)new InputStreamRequest(is, "application/octet-stream", null), new HttpHeader[]{new HttpHeader("Accept", "application/octet-stream")});
            this.handleResponseHeaders(httpResponse);
            AbstractHttpClient.checkResponseErrors((HttpResponse)httpResponse);
            HttpResponseStream result = new HttpResponseStream(httpResponse, httpResponse.getContent());
            StreamDocument streamDocument = new StreamDocument("1", "signature", (InputStream)result, "application/octet-stream");
            return streamDocument;
        }
    }

    private void handleResponseHeaders(HttpResponse response) {
        List headers = response.getHeader();
        for (HttpHeader header : headers) {
            for (ResponseHeaderListener listener : this.responseHeaderListeners) {
                if (!listener.willHandle(header.getName())) continue;
                listener.onHeader(header.getName(), header.getValue());
            }
        }
    }

    public O handleComplex(I input) throws IOException {
        return this.handleComplex(input, null);
    }

    public O handleComplex(I input, String keyid) throws IOException {
        Object path = "complex";
        if (keyid != null) {
            if (!keyid.startsWith("/")) {
                path = (String)path + "/";
            }
            path = (String)path + keyid;
        }
        URI uri = this.baseUriBuilder.clone().path((String)path).build();
        return (O)this.client.put(uri, (HttpRequest)new JSONEntity(input), new JSONBindingResponseHandler<O>(this.outputClass), new HttpHeader[]{new HttpHeader("Accept", "application/json")});
    }

    public void addResponseHeaderListener(ResponseHeaderListener rhl) {
        this.responseHeaderListeners.add(rhl);
    }

    public void removeResponseHeaderListener(ResponseHeaderListener rhl) {
        this.responseHeaderListeners.remove(rhl);
    }
}

