/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.utils.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.type.TypeFactory;
import de.governikus.csl.transport.AbstractHttpClient;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import java.io.IOException;
import java.io.InputStream;

public class JSONBindingResponseHandler<T>
implements HttpResponseHandler<T> {
    private Class<T> clazz;
    private ObjectMapper mapper;

    public JSONBindingResponseHandler(Class<T> clazz) {
        this.clazz = clazz;
        this.initMapper(new Class[0]);
    }

    public JSONBindingResponseHandler(Class<T> clazz, Class<?> ... allowedBaseTypes) {
        this.clazz = clazz;
        this.initMapper(allowedBaseTypes);
    }

    private void initMapper(Class<?> ... allowedBaseTypes) {
        TypeFactory tf = TypeFactory.defaultInstance().withClassLoader(this.clazz.getClassLoader());
        BasicPolymorphicTypeValidator.Builder builder = BasicPolymorphicTypeValidator.builder().allowIfBaseType(this.clazz);
        for (Class<?> allowedBaseType : allowedBaseTypes) {
            builder.allowIfBaseType(allowedBaseType);
        }
        BasicPolymorphicTypeValidator validator = builder.build();
        this.mapper = new ObjectMapper();
        this.mapper.setPolymorphicTypeValidator((PolymorphicTypeValidator)validator);
        this.mapper.setTypeFactory(tf);
    }

    public T handleResponse(HttpResponse resp) throws IOException {
        AbstractHttpClient.checkResponseErrors((HttpResponse)resp);
        try (InputStream is = resp.getContent();){
            Object object = this.mapper.readValue(is, this.clazz);
            return (T)object;
        }
    }
}

