/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.uom.LogHelper;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalTimeReentrantLock
extends ReentrantLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimalTimeReentrantLock.class);
    private static final long serialVersionUID = 136840600792706777L;
    private long minmalTimeBetweenCalls = 0L;
    private long lastCall = 0L;

    public MinimalTimeReentrantLock(long minmalTimeBetweenCalls) {
        this.minmalTimeBetweenCalls = minmalTimeBetweenCalls;
    }

    @Override
    public void lock() {
        super.lock();
        long now = System.currentTimeMillis();
        long toWait = this.lastCall + this.minmalTimeBetweenCalls - now;
        this.lastCall = now;
        if (toWait > 0L) {
            LOGGER.trace("Waiting {} ms", (Object)toWait);
            try {
                Thread.sleep(toWait);
            }
            catch (InterruptedException e) {
                LogHelper.logException(null, LOGGER, e);
            }
        }
    }

    @Override
    public void unlock() {
        super.unlock();
    }
}

