/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogOutputStream
extends FilterOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LogOutputStream.class);
    private OutputStream logOutputStream;

    @Override
    public void write(int b) throws IOException {
        this.write(b, true);
    }

    private void write(int b, boolean write) throws IOException {
        super.write(b);
        if (write && this.logOutputStream != null) {
            this.logOutputStream.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i], false);
        }
        if (this.logOutputStream != null) {
            this.logOutputStream.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.logOutputStream != null) {
            this.logOutputStream.flush();
        }
        LOG.debug("\nflush");
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.logOutputStream != null) {
            this.logOutputStream.close();
        }
        LOG.debug("\nclose");
    }

    public LogOutputStream(OutputStream out) {
        super(out);
        LOG.debug("\nstart logging output\n");
    }

    public LogOutputStream(OutputStream out, String filename) throws IOException {
        this(out, new FileOutputStream(filename));
    }

    public LogOutputStream(OutputStream out, OutputStream logOutputStream) throws IOException {
        super(out);
        LOG.debug("\nstart logging output\n");
        this.logOutputStream = logOutputStream;
    }
}

