/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.uom.util.SwapFile;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import javax.crypto.Cipher;

public final class KeyStoreUtil {
    private static final String PREFIX_TEMP_FILE_SWAP = "tom";
    private static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    public static final String KEYSTORE_JKS_PROVIDER = "SUN";
    public static final String KEYSTORE_TYPE_JKS = "JKS";
    public static final String UNLIMITED_STRENGTH_CHECK_ALGORITHM = "AES";

    private KeyStoreUtil() {
    }

    /*
     * Loose catch block
     */
    public static KeyStore loadKeyStore(InputStream is, char[] pin) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        File tempFile = null;
        tempFile = File.createTempFile(PREFIX_TEMP_FILE_SWAP, null);
        try {
            try (SwapFile swapFile = new SwapFile(tempFile, 16384);){
                swapFile.create(is);
                KeyStore tempKeyStore = CryptoProviderUtil.createKeyStore((String)KEYSTORE_TYPE_PKCS12);
                try {
                    tempKeyStore.load(swapFile.getStream(), pin);
                }
                catch (IOException ioe) {
                    if (ioe.getCause() != null && ioe.getCause() instanceof UnrecoverableKeyException) {
                        throw ioe;
                    }
                    tempKeyStore = KeyStore.getInstance(KEYSTORE_TYPE_JKS, KEYSTORE_JKS_PROVIDER);
                    tempKeyStore.load(swapFile.getStream(), pin);
                }
                KeyStore keyStore = tempKeyStore;
                return keyStore;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tempFile != null) {
                Files.delete(tempFile.toPath());
            }
        }
    }

    public static KeyStore createEmptyKeystore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        KeyStore newKeyStore = CryptoProviderUtil.createKeyStore();
        newKeyStore.load(null, null);
        return newKeyStore;
    }

    public static KeyStore clone(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, IOException, UnrecoverableKeyException {
        return KeyStoreUtil.clone(keyStore, null);
    }

    public static KeyStore clone(KeyStore keyStore, Collection<String> importAliases) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException, IOException, UnrecoverableKeyException {
        if (keyStore == null) {
            return null;
        }
        KeyStore clonedKeyStore = KeyStoreUtil.createEmptyKeystore();
        Enumeration<String> enumAliases = keyStore.aliases();
        while (enumAliases.hasMoreElements()) {
            String alias = enumAliases.nextElement();
            if (importAliases != null && !importAliases.contains(alias)) continue;
            if (keyStore.isKeyEntry(alias)) {
                clonedKeyStore.setKeyEntry(alias, keyStore.getKey(alias, null), null, keyStore.getCertificateChain(alias));
                continue;
            }
            clonedKeyStore.setCertificateEntry(alias, keyStore.getCertificate(alias));
        }
        return clonedKeyStore;
    }

    public static boolean isUnlimitedStrengthActivated() throws NoSuchAlgorithmException {
        return Cipher.getMaxAllowedKeyLength(UNLIMITED_STRENGTH_CHECK_ALGORITHM) == Integer.MAX_VALUE;
    }
}

