/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.uom.Plugin;
import de.governikus.csl.utils.GeneralException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class DataUtil {
    public static boolean isZip(byte[] hex) {
        return DataUtil.startsWith(hex, new byte[]{80, 75, 3, 4, 20, 0, 8, 8, 8, 0});
    }

    public static boolean isPEM(byte[] hex) {
        return DataUtil.startsWith(hex, new byte[]{45, 45, 45, 45, 45});
    }

    public static boolean isCMS(byte[] hex) {
        return DataUtil.startsWith(hex, new byte[]{48, -128});
    }

    public static boolean isX509(byte[] hex) {
        return DataUtil.startsWith(hex, new byte[]{48, -126});
    }

    public static boolean isPDF(byte[] hex) {
        return DataUtil.startsWith(hex, new byte[]{37, 80, 68, 70});
    }

    public static boolean isBase64(byte[] hex) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(hex);){
            Base64.getDecoder().wrap(is).read();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean isXML(byte[] hex) {
        byte[] xmlHeader = new byte[]{60, 63, 120, 109, 108};
        byte[] xmlNs = new byte[]{104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 50, 48, 48, 49, 47, 88, 77, 76, 83, 99, 104, 101, 109, 97, 45, 105, 110, 115, 116, 97, 110, 99, 101};
        return DataUtil.startsWith(hex, xmlHeader) || DataUtil.contains(hex, xmlNs);
    }

    public static boolean isOSCI(byte[] hex) {
        byte[] osciNs = new byte[]{104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 111, 115, 99, 105, 46, 100, 101, 47, 50, 48, 48, 50, 47, 48, 52, 47, 111, 115, 99, 105};
        return DataUtil.isXML(hex) && DataUtil.contains(hex, osciNs);
    }

    private static boolean startsWith(byte[] hex, byte[] pattern) {
        return Arrays.areEqual((byte[])Arrays.copyOf((byte[])hex, (int)pattern.length), (byte[])pattern);
    }

    private static boolean contains(byte[] hex, byte[] pattern) {
        for (int i = 0; i < hex.length && i < 4096; ++i) {
            if (hex[i] != pattern[0]) continue;
            boolean xml = true;
            for (int j = 0; j < pattern.length; ++j) {
                if (pattern[j] == hex[j + i]) continue;
                xml = false;
                break;
            }
            if (!xml) continue;
            return true;
        }
        return false;
    }

    public static Plugin.PluginID getDataTypeQuietly(byte[] data) {
        try {
            return DataUtil.getDataType(data);
        }
        catch (IOException e) {
            throw new GeneralException((Throwable)e);
        }
    }

    public static Plugin.PluginID getDataType(byte[] data) throws IOException {
        if (DataUtil.isPEM(data)) {
            try (PemReader pr = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(data)));){
                PemObject pemObject = pr.readPemObject();
                data = pemObject.getContent();
            }
        }
        if (DataUtil.isCMS(data)) {
            return Plugin.PluginID.VALIDATE_CADES;
        }
        if (DataUtil.isX509(data)) {
            return Plugin.PluginID.VALIDATE_X509;
        }
        if (DataUtil.isZip(data)) {
            return Plugin.PluginID.VALIDATE_ZIP;
        }
        if (DataUtil.isPDF(data)) {
            return Plugin.PluginID.VALIDATE_PADES;
        }
        if (DataUtil.isOSCI(data)) {
            return Plugin.PluginID.VALIDATE_OSCI;
        }
        if (DataUtil.isXML(data)) {
            return Plugin.PluginID.VALIDATE_XADES;
        }
        return null;
    }

    public static enum DataType {
        CMS,
        X509,
        XML,
        OSCI;

    }
}

