/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.validate.commons;

public enum CRLReason {
    UNSPECIFIED(0, "urn:etsi:019102:revocationReason:unspecified"),
    KEY_COMPROMISE(1, "urn:etsi:019102:revocationReason:keyCompromise"),
    CA_COMPROMISE(2, "urn:etsi:019102:revocationReason:cACompromise"),
    AFFILIATION_CHANGED(3, "urn:etsi:019102:revocationReason:affiliationChanged"),
    SUPERSEDED(4, "urn:etsi:019102:revocationReason:superseded"),
    CESSATION_OF_OPERATION(5, "urn:etsi:019102:revocationReason:cessationOfOperation"),
    CERTIFICATE_HOLD(6, "urn:etsi:019102:revocationReason:certificateHold"),
    REMOVE_FROM_CRL(8, "urn:etsi:019102:revocationReason:removeFromCRL"),
    PRIVILIGE_WITHDRAWN(9, "urn:etsi:019102:revocationReason:privilegeWithdrawn"),
    AA_COMPROMISE(10, "urn:etsi:019102:revocationReason:AACompromise");

    private int reasonCode;
    private String ts119102Uri;

    private CRLReason(int code, String ts119102Uri) {
        this.reasonCode = code;
        this.ts119102Uri = ts119102Uri;
    }

    public static CRLReason fromCode(int code) {
        for (CRLReason cr : CRLReason.values()) {
            if (cr.reasonCode != code) continue;
            return cr;
        }
        return null;
    }

    public static CRLReason parse(String value) {
        return CRLReason.valueOf(value);
    }

    public static String print(CRLReason value) {
        return value.name();
    }

    public String getTs119102Uri() {
        return this.ts119102Uri;
    }
}

