/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.validate;

import de.governikus.csl.uom.validate.CertificateQualityResult;
import de.governikus.csl.uom.validate.CertificateType;
import de.governikus.csl.uom.validate.Quality;
import de.governikus.csl.uom.validate.SignatureQualityResult;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface QualityResult
extends ResultAggregator {
    public SignatureQualityResult getSignatureQualityResult();

    public CertificateQualityResult getCertificateQualityResult();

    default public boolean isNull() {
        return this.getCertificateQualityResult() == null || this.getSignatureQualityResult() == null;
    }

    default public boolean isEmpty() {
        return this.isNull();
    }

    default public boolean isQES() {
        if (this.isEmpty()) {
            return false;
        }
        return MajorTotalResult.TOTAL_PASSED.equals((Object)this.getOverallResult(true).getMajor()) && Quality.QC.equals((Object)this.getCertificateQualityResult().getQuality());
    }

    default public List<String> getSvrQualityURLs() {
        MajorTotalResult qscdMajor;
        TLType tlType;
        Quality quality;
        if (this.isNull()) {
            return Collections.singletonList("https://www.governikus.de/val-uri/signature-level-types/unknown");
        }
        CertificateQualityResult certQualityResult = this.getCertificateQualityResult();
        SignatureQualityResult sigQualityResult = this.getSignatureQualityResult();
        ArrayList<String> svrQualityURLs = new ArrayList<String>();
        CertificateType certType = certQualityResult.getCertificateType();
        if (certType != null) {
            svrQualityURLs.add("https://www.governikus.de/val-uri/certificate-type/" + certType.name());
        }
        if ((quality = certQualityResult.getQuality()) != null) {
            svrQualityURLs.add("https://www.governikus.de/val-uri/quality/" + quality.name());
        }
        if ((quality = certQualityResult.getAssumedQuality()) != null) {
            svrQualityURLs.add("https://www.governikus.de/val-uri/assumed-quality/" + quality.name());
        }
        if ((tlType = certQualityResult.getTLType()) != null) {
            svrQualityURLs.add("https://www.governikus.de/val-uri/trusted-list-type/" + tlType.name());
        }
        if ((qscdMajor = sigQualityResult.getMajor()) != null) {
            svrQualityURLs.add("https://www.governikus.de/val-uri/qscd/" + (Object)((Object)qscdMajor));
        }
        return svrQualityURLs;
    }
}

