/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.util.TempDataManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempDataManagerImpl
implements TempDataManager {
    private static final int DELETE_RETRIES = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(TempDataManagerImpl.class);
    private List<Closeable> closeables;
    private List<File> files;
    private List<TempDataManagerImpl> subManager;
    private Path baseDir;

    public TempDataManagerImpl(String folderInJavaIOTmpDir) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpDirectory = new File(tmpDir);
        File folder = new File(tmpDirectory, folderInJavaIOTmpDir);
        this.init(folder);
    }

    public TempDataManagerImpl(File baseDir) {
        this.init(baseDir);
    }

    private void init(File folder) {
        this.baseDir = folder.toPath();
        this.closeables = new ArrayList<Closeable>();
        this.files = new ArrayList<File>();
        this.subManager = new ArrayList<TempDataManagerImpl>();
    }

    public void setTempDirectory(File tempDir) throws IllegalStateException {
    }

    public boolean cleanUp() {
        LOGGER.info("Clean-Up");
        boolean result = true;
        Iterator<TempDataManagerImpl> iterator1 = this.subManager.iterator();
        while (iterator1.hasNext()) {
            TempDataManagerImpl sub = iterator1.next();
            if (sub.cleanUp()) {
                iterator1.remove();
                continue;
            }
            LOGGER.warn("Couldn't cleanup sub-manager");
            result = false;
        }
        Iterator<Closeable> iterator3 = this.closeables.iterator();
        while (iterator3.hasNext()) {
            Closeable closeable = iterator3.next();
            try {
                closeable.close();
                iterator3.remove();
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't close closeable");
                result = false;
            }
        }
        Iterator<File> iterator2 = this.files.iterator();
        while (iterator2.hasNext()) {
            File tempFile = iterator2.next();
            if (TempDataManagerImpl.delete(tempFile)) {
                iterator2.remove();
                continue;
            }
            LOGGER.warn("Couldn't delete file: " + tempFile.getAbsolutePath());
            result = false;
        }
        if (this.baseDir.toFile().exists()) {
            try {
                Files.delete(this.baseDir);
            }
            catch (IOException e) {
                LOGGER.warn("Could not delete file");
                result = false;
            }
        }
        return result;
    }

    private static boolean delete(File file) {
        for (int i = 0; i < 5; ++i) {
            if (!file.delete() && file.exists()) continue;
            return true;
        }
        return false;
    }

    public void add(File file) {
        this.files.add(file);
    }

    public void add(Closeable closeable) {
        this.closeables.add(closeable);
    }

    public File createTempFolder(String prefix) {
        this.assureExistingOfBaseDir();
        try {
            Path createTempDirectory = Files.createTempDirectory(this.baseDir, prefix, new FileAttribute[0]);
            File file = createTempDirectory.toFile();
            this.add(file);
            return file;
        }
        catch (IOException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Couldn't create subfolder with prefix \"" + prefix + "\" in " + this.baseDir.toString(), (Throwable)e);
            }
            return null;
        }
    }

    public File createTempFile(String prefix, String suffix) {
        this.assureExistingOfBaseDir();
        try {
            Path tempFile = Files.createTempFile(this.baseDir, prefix, suffix, new FileAttribute[0]);
            File file = tempFile.toFile();
            this.add(file);
            return file;
        }
        catch (IOException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Couldn't create subfolder with prefix \"" + prefix + "\" and suffix \"" + suffix + "\" in " + this.baseDir.toString(), (Throwable)e);
            }
            return null;
        }
    }

    public TempDataManager createChildManager(String childDirectoryName) throws IllegalArgumentException {
        File tempFolder = this.createTempFolder(childDirectoryName);
        TempDataManagerImpl child = new TempDataManagerImpl(tempFolder);
        this.subManager.add(child);
        return child;
    }

    private boolean exists(String childFilename) {
        return new File(this.baseDir.toFile(), childFilename).exists();
    }

    public TempDataManager createChildManager() {
        String subDirName = UUID.randomUUID().toString();
        while (this.exists(subDirName)) {
            subDirName = UUID.randomUUID().toString();
        }
        return this.createChildManager(subDirName);
    }

    public File createFile(String childFilename) {
        this.assureExistingOfBaseDir();
        File file = null;
        if (this.exists(childFilename)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Couldn't create file with \"{}\" in {}, file exists", (Object)childFilename, (Object)this.baseDir);
            }
        } else {
            file = new File(this.baseDir.toFile(), childFilename);
            this.add(file);
        }
        return file;
    }

    private void assureExistingOfBaseDir() {
        block3: {
            if (!this.baseDir.toFile().exists()) {
                try {
                    Files.createDirectories(this.baseDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Could not create directory " + this.baseDir + ".", (Throwable)e);
                }
            }
        }
    }
}

