/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.StreamProvider;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class SwapFileOutputStream
extends DeferredFileOutputStream
implements StreamProvider {
    private boolean closed;
    private byte[] internalByteArray;

    public SwapFileOutputStream(File tempFile, int threshold) {
        super(threshold, tempFile);
    }

    public void close() throws IOException {
        if (!this.closed) {
            File file;
            this.closed = true;
            try {
                this.flush();
            }
            finally {
                super.close();
            }
            if (this.isInMemory() && (file = this.getFile()) != null) {
                Files.delete(file.toPath());
            }
        }
    }

    public void consume(InputStream is) throws IOException {
        try {
            IOUtils.copyLarge((InputStream)is, (OutputStream)((Object)this));
        }
        finally {
            SwapFileOutputStream.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isInMemory()) {
            SwapFileOutputStream swapFileOutputStream = this;
            synchronized (swapFileOutputStream) {
                if (this.internalByteArray == null) {
                    this.internalByteArray = this.getData();
                }
            }
            return new ByteArrayInputStream(this.internalByteArray);
        }
        return Files.newInputStream(this.getFile().toPath(), new OpenOption[0]);
    }

    public long getSize() {
        if (this.isInMemory()) {
            return this.getByteCount();
        }
        return this.getFile().length();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

