/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.util.SwapFileOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SwapFile
implements Closeable {
    private SwapFileOutputStream swapFileOS;
    private List<InputStream> openStreamList = new ArrayList<InputStream>();
    public static final int DEFAULT_MAX_MEMORY_THRESHOLD = Short.MAX_VALUE;

    public SwapFile(File tempFile) {
        this(tempFile, Short.MAX_VALUE);
    }

    public SwapFile(File tempFile, int threshold) {
        this.swapFileOS = new SwapFileOutputStream(tempFile, threshold);
    }

    public void create(InputStream is) throws IOException {
        try {
            this.consume(is);
        }
        finally {
            this.closeSwapStream();
        }
    }

    protected void consume(InputStream is) throws IOException {
        try {
            this.swapFileOS.consume(is);
        }
        finally {
            SwapFileOutputStream.closeQuietly(is);
        }
    }

    protected SwapFileOutputStream getSwapStream() {
        return this.swapFileOS;
    }

    protected void closeSwapStream() throws IOException {
        this.swapFileOS.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStream() throws IOException {
        InputStream is = this.swapFileOS.getInputStream();
        List<InputStream> list = this.openStreamList;
        synchronized (list) {
            this.openStreamList.add(is);
        }
        return is;
    }

    public long getSize() {
        return this.swapFileOS.getSize();
    }

    public boolean isInMemory() {
        return this.swapFileOS.isInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<InputStream> list = this.openStreamList;
        synchronized (list) {
            Iterator<InputStream> openStreamIT = this.openStreamList.iterator();
            while (openStreamIT.hasNext()) {
                SwapFileOutputStream.closeQuietly(openStreamIT.next());
                openStreamIT.remove();
            }
        }
    }

    public void delete() throws IOException {
        this.closeSwapStream();
        this.close();
        if (!this.isInMemory() && !this.swapFileOS.getFile().delete()) {
            throw new IOException("Cannot delete '" + this.swapFileOS.getFile().getAbsolutePath() + "'!");
        }
    }
}

