/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.commons.io.IOUtils;

public class SimpleDataHandler<T extends InputStream>
extends DataHandler {
    private T stream;
    private File file;
    private static final String PREFIX = "sdHandler";
    private static final String SUFFIX = ".tmp";

    public SimpleDataHandler(File file, String mimeType) {
        this(null, file, mimeType);
    }

    private SimpleDataHandler(T stream, File file, String mimeType) {
        super(stream, mimeType);
        this.stream = stream;
        this.file = file;
    }

    public SimpleDataHandler(T stream, String mimeType) {
        this(stream, null, mimeType);
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.stream instanceof ByteArrayInputStream) {
            ((InputStream)this.stream).reset();
            return this.stream;
        }
        this.file = File.createTempFile(PREFIX, SUFFIX);
        this.file.deleteOnExit();
        try (T is = this.stream;
             FileOutputStream out = new FileOutputStream(this.file);){
            IOUtils.copy(is, (OutputStream)out);
        }
        this.stream = null;
        return new FileInputStream(this.file);
    }
}

