/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.util.DigestCipherProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.util.Objects;
import javax.crypto.CipherOutputStream;

public class SecureOutputStream
extends DigestOutputStream {
    private byte[] digest = null;
    protected DigestCipherProvider dcp;

    public SecureOutputStream(OutputStream stream, DigestCipherProvider dcp) throws NullPointerException {
        super(SecureOutputStream.createCipherOutputStream(stream, Objects.requireNonNull(dcp, "DigestCipherProvider is required")), dcp.createDigest());
        this.dcp = dcp;
    }

    private static OutputStream createCipherOutputStream(OutputStream os, DigestCipherProvider dcp) {
        return new CipherOutputStream(os, dcp.createCipher(1));
    }

    public byte[] getDigest() throws IllegalStateException {
        if (this.digest == null) {
            throw new IllegalStateException("write final block not written - stream currently not closed");
        }
        return this.digest;
    }

    @Override
    public void close() throws IOException {
        this.digest = this.getMessageDigest().digest();
        super.close();
    }

    @Override
    public void on(boolean on) {
        throw new UnsupportedOperationException("digest calculation not changeable");
    }
}

