/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.util.DigestCipherProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.CipherInputStream;

public class SecureInputStream
extends DigestInputStream {
    private byte[] expectedDigest = null;
    protected DigestCipherProvider dcp;

    public SecureInputStream(InputStream stream, DigestCipherProvider dcp, byte[] expectedDigest) throws NullPointerException {
        super(SecureInputStream.createCipherInputStream(stream, Objects.requireNonNull(dcp, "DigestCipherProvider is required")), dcp.createDigest());
        this.expectedDigest = expectedDigest;
        this.dcp = dcp;
    }

    private static InputStream createCipherInputStream(InputStream is, DigestCipherProvider dcp) {
        return new CipherInputStream(is, dcp.createCipher(2));
    }

    @Override
    public void close() throws IOException {
        byte[] digest = this.getMessageDigest().digest();
        super.close();
        if (!Arrays.equals(digest, this.expectedDigest)) {
            throw new IOException("content was changed, system was compromised, content attacked");
        }
    }

    @Override
    public void on(boolean on) {
        throw new UnsupportedOperationException("digest calculation not changeable");
    }
}

