/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSelector {
    private String filePattern;
    private String folderPattern;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSelector.class);

    public FileSelector(String filePattern, String folderPattern) {
        this.filePattern = filePattern;
        this.folderPattern = folderPattern;
    }

    public List<File> getFiles(String startingFolder) {
        URL url;
        File folder = new File(startingFolder);
        if (!folder.isAbsolute() && (url = this.getClass().getClassLoader().getResource(startingFolder)) != null) {
            try {
                folder = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Invalid URL.", (Throwable)e);
            }
        }
        ArrayList<File> result = new ArrayList<File>();
        if (folder.isDirectory()) {
            this.processFolder(folder, result);
        }
        return result;
    }

    private void processFolder(File folder, List<File> result) {
        File[] childs;
        String folderName = folder.getName();
        boolean matchesFolder = true;
        if (this.folderPattern != null) {
            matchesFolder = Pattern.matches(this.folderPattern, folderName);
        }
        if (matchesFolder) {
            for (File child : childs = folder.listFiles()) {
                String fileName = child.getName();
                if (!child.isFile()) continue;
                boolean matchesFile = true;
                if (this.filePattern != null) {
                    matchesFile = Pattern.matches(this.filePattern, fileName);
                }
                if (!matchesFile) continue;
                result.add(child);
            }
        }
        for (File child : childs = folder.listFiles()) {
            if (!child.isDirectory()) continue;
            this.processFolder(child, result);
        }
    }

    public static void main(String[] args) {
        FileSelector selector = new FileSelector("Signature.+", "ETSI");
        List<File> matchingFiles = selector.getFiles("D:/ETSI-Plugtest/InitialPackage_v2.1");
        for (File f : matchingFiles) {
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(f.getAbsolutePath());
        }
        selector = new FileSelector(".+\\.crt$", null);
        matchingFiles = selector.getFiles("D:/ETSI-Plugtest/InitialPackage_v2.1");
        for (File f : matchingFiles) {
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(f.getAbsolutePath());
        }
    }
}

