/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public abstract class ConcatenatedInputStream
extends InputStream {
    private List<InputStream> streams = new ArrayList<InputStream>();
    private InputStream currentStream = null;

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentStream == null) {
            this.currentStream = this.getNextStream();
        }
        int currentOffset = off;
        int bytesLeft = len;
        int bytesRead = 0;
        while (this.currentStream != null && bytesLeft > 0) {
            int numBytesRead = IOUtils.read((InputStream)this.currentStream, (byte[])b, (int)currentOffset, (int)bytesLeft);
            if (numBytesRead < 0) {
                this.currentStream = this.getNextStream();
                continue;
            }
            if (numBytesRead != bytesLeft) {
                this.currentStream = this.getNextStream();
            }
            currentOffset += numBytesRead;
            bytesRead += numBytesRead;
            bytesLeft -= numBytesRead;
        }
        if (bytesRead == 0 && this.currentStream == null) {
            return -1;
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        if (this.currentStream == null) {
            this.currentStream = this.getNextStream();
        }
        if (this.currentStream != null) {
            do {
                int read;
                if ((read = this.currentStream.read()) >= 0) {
                    return read;
                }
                this.currentStream = this.getNextStream();
            } while (this.currentStream != null);
        }
        return -1;
    }

    protected abstract InputStream getNextInputStream() throws IOException;

    private InputStream getNextStream() throws IOException {
        InputStream is = this.getNextInputStream();
        if (is != null) {
            this.streams.add(is);
        }
        return is;
    }

    @Override
    public void close() throws IOException {
        for (InputStream is : this.streams) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

