/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.util.Environment;
import de.governikus.csl.uom.util.SwapFileOutputStream;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class CSLDocumentDataHandler<T>
extends DataHandler {
    public static final String MIME_TYPE_CMS_SIGNED = "application/pkcs7-signature";
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String MIME_TYPE_XML = "application/xml";

    public CSLDocumentDataHandler(T content, String mimeType) {
        super(content, mimeType);
    }

    public static CSLDocumentDataHandler<Document> createCMSDocumentDataHandler(Document content) {
        return new CSLDocumentDataHandler<Document>(content, MIME_TYPE_CMS_SIGNED);
    }

    public static CSLDocumentDataHandler<org.w3c.dom.Document> createXMLDOMDocumentDataHandler(org.w3c.dom.Document content, final Environment env) {
        return new CSLDocumentDataHandler<org.w3c.dom.Document>(content, MIME_TYPE_XML){

            public InputStream getInputStream() throws IOException {
                File tempFile = null;
                if (env != null) {
                    tempFile = env.getTempDataManager().createTempFile("xmldata", "tmp");
                } else {
                    tempFile = File.createTempFile("xml", "withoutTmpManager");
                }
                try (SwapFileOutputStream buffer = new SwapFileOutputStream(tempFile, 524288);){
                    StreamResult streamResult = new StreamResult((OutputStream)((Object)buffer));
                    try {
                        TransformerFactory tf = TransformerFactory.newInstance();
                        SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)tf);
                        tf.newTransformer().transform(new DOMSource((org.w3c.dom.Document)this.getContent()), streamResult);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new IOException("failed to create stream: " + e.getMessage(), e);
                    }
                    InputStream inputStream = buffer.getInputStream();
                    return inputStream;
                }
            }
        };
    }

    public static CSLDocumentDataHandler<org.w3c.dom.Document> createXMLDocumentDataHandler(Document content, Environment env) throws IOException {
        return CSLDocumentDataHandler.createXMLDOMDocumentDataHandler(CSLDocumentDataHandler.createDocument(content.getInputStream()), env);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static org.w3c.dom.Document createDocument(InputStream stream) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try (InputStream is = stream;){
                org.w3c.dom.Document document = db.parse(is);
                return document;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

