/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.util.DigestCipherProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public abstract class AbstractDigestCipherProvider
implements DigestCipherProvider {
    protected final SecureRandom secureRandom;
    private final SecretKey secretKey;
    private final AlgorithmParameterSpec spec;
    private final byte[] aad;
    private final String cipherAlgorithmName;
    private final String jceCipherProviderName;
    private final String jceDigestProviderName;
    private final String secretKeyAlgorithmName;
    private final int secretKeySize;
    private final String digestAlgorithmName;

    public static byte[] generateRandomValue(SecureRandom secureRandom, int randomLength) throws NoSuchAlgorithmException, IllegalArgumentException {
        if (secureRandom == null) {
            throw new IllegalArgumentException("secure random can not be null");
        }
        if (randomLength <= 0) {
            throw new IllegalArgumentException("random length must be greater than zero: " + randomLength);
        }
        byte[] randomBytes = new byte[randomLength];
        secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }

    @Override
    public final Cipher createCipher(int opmode) {
        try {
            return AbstractDigestCipherProvider.generateCipher(this.cipherAlgorithmName, this.jceCipherProviderName, opmode, this.secretKey, this.spec, this.aad);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public abstract AlgorithmParameterSpec generateAlgorithmParameterSpec() throws NoSuchAlgorithmException;

    public static SecretKey generateSecretKey(String keyAlgorithm, int keySize, SecureRandom random) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(keyAlgorithm);
        keyGen.init(keySize, random);
        return keyGen.generateKey();
    }

    public static Cipher generateCipher(String cipherAlgorithmName, String jceProviderName, int opmode, SecretKey secretKey, AlgorithmParameterSpec spec, byte[] aad) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalArgumentException {
        if (cipherAlgorithmName == null || cipherAlgorithmName.isEmpty()) {
            throw new IllegalArgumentException("cipher algorithm name can not be null or empty");
        }
        if (1 != opmode && 2 != opmode) {
            throw new IllegalArgumentException("invalid operation mode, only Cipher.ENCRYPT_MODE or Cipher.DECRYPT_MODE are possible");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secret key can not be null");
        }
        Cipher cipher = AbstractDigestCipherProvider.generateCipher(cipherAlgorithmName, jceProviderName);
        cipher.init(opmode, (Key)secretKey, spec);
        if (aad != null && aad.length > 0) {
            cipher.updateAAD(aad);
        }
        return cipher;
    }

    public AbstractDigestCipherProvider(String digestAlgorithmName, String jceDigestProviderName, String cipherAlgorithmName, String jceCipherProviderName, SecureRandom secureRandom, String secretKeyAlgorithmName, int secretKeySize, byte[] aad) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalArgumentException {
        if (digestAlgorithmName == null || digestAlgorithmName.isEmpty()) {
            throw new IllegalArgumentException("digest algorithm name can not be null or empty");
        }
        if (cipherAlgorithmName == null || cipherAlgorithmName.isEmpty()) {
            throw new IllegalArgumentException("cipher algorithm name can not be null or empty");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("SecureRandom can not be null");
        }
        if (secretKeyAlgorithmName == null || secretKeyAlgorithmName.isEmpty()) {
            throw new IllegalArgumentException("secret key algorithm name can not be null or empty");
        }
        if ((secretKeySize & -secretKeySize) != secretKeySize) {
            throw new IllegalArgumentException("secret key size must be power of 2");
        }
        if (aad == null) {
            throw new IllegalArgumentException("aad can not be null");
        }
        AbstractDigestCipherProvider.generateDigest(digestAlgorithmName, jceDigestProviderName);
        SecretKey secretKey = AbstractDigestCipherProvider.generateSecretKey(secretKeyAlgorithmName, secretKeySize, secureRandom);
        AlgorithmParameterSpec spec = this.generateAlgorithmParameterSpec();
        AbstractDigestCipherProvider.generateCipher(cipherAlgorithmName, jceCipherProviderName, 1, secretKey, spec, aad);
        AbstractDigestCipherProvider.generateCipher(cipherAlgorithmName, jceCipherProviderName, 2, secretKey, spec, aad);
        this.digestAlgorithmName = digestAlgorithmName;
        this.jceDigestProviderName = jceDigestProviderName;
        this.cipherAlgorithmName = cipherAlgorithmName;
        this.jceCipherProviderName = jceCipherProviderName;
        this.secureRandom = secureRandom;
        this.secretKeyAlgorithmName = secretKeyAlgorithmName;
        this.secretKeySize = secretKeySize;
        this.secretKey = secretKey;
        this.spec = spec;
        this.aad = aad;
    }

    @Override
    public final MessageDigest createDigest() {
        try {
            return AbstractDigestCipherProvider.generateDigest(this.digestAlgorithmName, this.jceDigestProviderName);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            return null;
        }
    }

    @Override
    public final String getCipherAlgorithmName() {
        return this.cipherAlgorithmName;
    }

    @Override
    public final String getSecretKeyAlgorithmName() {
        return this.secretKeyAlgorithmName;
    }

    @Override
    public final String getDigestAlgorithmName() {
        return this.digestAlgorithmName;
    }

    @Override
    public final int getSecretKeySize() {
        return this.secretKeySize;
    }

    @Override
    public final String getJceCipherProviderName() {
        return this.jceCipherProviderName;
    }

    @Override
    public final String getJceDigestProviderName() {
        return this.jceDigestProviderName;
    }

    public static Cipher generateCipher(String algorithmName, String jceProviderName) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (algorithmName == null || algorithmName.isEmpty()) {
            throw new IllegalArgumentException("algorithm name can not be null or empty");
        }
        return jceProviderName == null || jceProviderName.isEmpty() ? Cipher.getInstance(algorithmName) : Cipher.getInstance(algorithmName, jceProviderName);
    }

    public static MessageDigest generateDigest(String algorithmName, String jceProviderName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (algorithmName == null || algorithmName.isEmpty()) {
            throw new IllegalArgumentException("algorithm name can not be null or empty");
        }
        return jceProviderName == null || jceProviderName.isEmpty() ? MessageDigest.getInstance(algorithmName) : MessageDigest.getInstance(algorithmName, jceProviderName);
    }
}

