/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.util;

import de.governikus.csl.uom.util.AbstractDigestCipherProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;

public class AESSecretKeyDigestGCMCipherProvider
extends AbstractDigestCipherProvider {
    public static final String JCE_CIPHER_PROVIDER_NAME = "SunJCE";
    public static final String JCE_DIGEST_PROVIDER_NAME = null;
    public static final String CIPHER_ALGORITHM_NAME = "AES/GCM/NoPadding";
    public static final String DIGEST_ALGORITHM_NAME = "SHA-256";
    public static final String SECRET_KEY_ALGORITHM_NAME = "AES";
    public static final int RANDOM_VALUE_LENGTH = 10;
    public static final int SECRET_KEY_SIZE = 256;
    public static final int GCM_NONCE_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 16;

    public static SecureRandom generateSecureRandom() throws NoSuchAlgorithmException {
        return new SecureRandom();
    }

    public AESSecretKeyDigestGCMCipherProvider() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        this(AESSecretKeyDigestGCMCipherProvider.generateRandomValue(AESSecretKeyDigestGCMCipherProvider.generateSecureRandom(), 10));
    }

    public AESSecretKeyDigestGCMCipherProvider(byte[] aad) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        super(DIGEST_ALGORITHM_NAME, JCE_DIGEST_PROVIDER_NAME, CIPHER_ALGORITHM_NAME, JCE_CIPHER_PROVIDER_NAME, AESSecretKeyDigestGCMCipherProvider.generateSecureRandom(), SECRET_KEY_ALGORITHM_NAME, 256, aad);
    }

    @Override
    public AlgorithmParameterSpec generateAlgorithmParameterSpec() throws NoSuchAlgorithmException {
        byte[] nonce = new byte[12];
        AESSecretKeyDigestGCMCipherProvider.generateSecureRandom().nextBytes(nonce);
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
        return spec;
    }
}

