/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.CertificateValidationServiceResourceReferenceParameter;
import de.governikus.csl.uom.res.TimestampServiceResourceReferenceParameter;
import de.governikus.csl.uom.res.TrustedAnchorServiceResourceReferenceParameter;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AbstractSignProperty;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.tsp.TimeStampToken;

public abstract class Timestamp
extends AbstractSignProperty {
    public static final boolean DEFAULT_CRLS_USED = false;
    public static final boolean DEFAULT_OCRP_RESPONSES_USED = true;
    public static final boolean DEFAULT_VALIDATION_DATA = false;
    private CertificateValidationServiceResourceReferenceParameter certificateValidationServiceResourceReference;
    private final boolean crlsUsed;
    private final String digestAlgorithmURI;
    private final boolean ocspResponsesUsed;
    private final List<TimeStampToken> timestamps;
    private TimestampServiceResourceReferenceParameter timestampService;
    private TrustedAnchorServiceResourceReferenceParameter trustedAnchorService;
    private final boolean validationDataUsed;

    private static void checkConstructorDigestAlgorithmArgument(String digestAlgorithmURI) {
        if (digestAlgorithmURI == null || digestAlgorithmURI.isEmpty()) {
            throw new IllegalArgumentException("digest algorithm required");
        }
        String jceDigestAlgorithm = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(digestAlgorithmURI);
        if (jceDigestAlgorithm == null) {
            throw new IllegalArgumentException("digest algorithm not mappable to a JCE algorithm: " + digestAlgorithmURI);
        }
    }

    public Timestamp(String digestAlgorithmURI) {
        this(digestAlgorithmURI, null, true, (List<ConstraintSignPolicy.EncodingConstraint>)null);
    }

    public Timestamp(String digestAlgorithmURI, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(digestAlgorithmURI, null, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public Timestamp(String digestAlgorithmURI, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(digestAlgorithmURI, null, useDefaultEncoding, encodings);
    }

    public Timestamp(String digestAlgorithmURI, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(digestAlgorithmURI, true, encodings);
    }

    public Timestamp(String digestAlgorithmURI, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(digestAlgorithmURI, null, true, encodings);
    }

    public Timestamp(String digestAlgorithmURI, List<TimeStampToken> timestamps, boolean validationDataUsed, boolean ocspResponsesUsed, boolean crlsUsed, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncoding, encodings);
        Timestamp.checkConstructorDigestAlgorithmArgument(digestAlgorithmURI);
        this.digestAlgorithmURI = digestAlgorithmURI;
        this.timestamps = timestamps;
        this.validationDataUsed = validationDataUsed;
        this.crlsUsed = validationDataUsed && crlsUsed;
        this.ocspResponsesUsed = validationDataUsed && ocspResponsesUsed;
    }

    public Timestamp(String digestAlgorithmURI, List<TimeStampToken> timestamps, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(digestAlgorithmURI, timestamps, false, true, false, useDefaultEncoding, encodings);
    }

    public final boolean areCRLsUsed() {
        return this.crlsUsed;
    }

    public final boolean areOCSPResponsesUsed() {
        return this.ocspResponsesUsed;
    }

    public final String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }

    public final List<TimeStampToken> getTimestamps() {
        return this.timestamps;
    }

    public final boolean isValidationDataUsed() {
        return this.validationDataUsed;
    }

    public CertificateValidationServiceResourceReferenceParameter getCertificateValidationService() {
        return this.certificateValidationServiceResourceReference;
    }

    public void setCertificateValidationService(CertificateValidationServiceResourceReferenceParameter certificateValidationService) {
        this.certificateValidationServiceResourceReference = certificateValidationService;
    }

    public TimestampServiceResourceReferenceParameter getTimestampService() {
        return this.timestampService;
    }

    public void setTimestampService(TimestampServiceResourceReferenceParameter timestampService) {
        this.timestampService = timestampService;
    }

    public TrustedAnchorServiceResourceReferenceParameter getTrustedAnchorService() {
        return this.trustedAnchorService;
    }

    public void setTrustedAnchorService(TrustedAnchorServiceResourceReferenceParameter trustedAnchorService) {
        this.trustedAnchorService = trustedAnchorService;
    }
}

