/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AnySignedProperty;
import de.governikus.csl.uom.sign.props.SinglePropertyAttribute;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningTime
extends AnySignedProperty<Calendar>
implements SinglePropertyAttribute {
    public static final Calendar CREATE_AT_SIGNATURE_PROCESS = GregorianCalendar.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(SigningTime.class);
    public static final List<String> OIDS = Collections.singletonList(PKCSObjectIdentifiers.pkcs_9_at_signingTime.getId());
    public static final List<QName> NODENAMES = Collections.singletonList(new QName("http://uri.etsi.org/01903/v1.3.2#", "SigningTime"));

    public SigningTime(Calendar signingTime, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(signingTime, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public SigningTime(Calendar signingTime, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(signingTime == null ? CREATE_AT_SIGNATURE_PROCESS : signingTime, useDefaultEncoding, encodings);
    }

    public SigningTime(Calendar signingTime, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(signingTime, true, Arrays.asList(encodings));
    }

    public SigningTime(Calendar signingTime, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(signingTime, true, encodings);
    }

    public SigningTime(boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this((Calendar)null, useDefaultEncoding, Arrays.asList(encodings));
    }

    public SigningTime(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(CREATE_AT_SIGNATURE_PROCESS, useDefaultEncoding, encodings);
    }

    public SigningTime(ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(CREATE_AT_SIGNATURE_PROCESS, true, Arrays.asList(encodings));
    }

    public SigningTime(List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(CREATE_AT_SIGNATURE_PROCESS, true, encodings);
    }

    @Override
    public Calendar getAny() {
        Calendar calendar = (Calendar)super.getAny();
        if (calendar == CREATE_AT_SIGNATURE_PROCESS) {
            LOG.debug("creating time");
            GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
            gc.setTime(new Date(System.currentTimeMillis()));
            calendar = gc;
        }
        return calendar;
    }

    public Calendar getSigningTime() {
        return this.getAny();
    }

    @Override
    public List<QName> getNodeNames() {
        return NODENAMES;
    }

    @Override
    public List<String> getOIDs() {
        return OIDS;
    }
}

