/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AbstractSignedProperty;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.types.CertificateValue;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SigningCertificate
extends AbstractSignedProperty {
    protected static final List<String> OIDS = Collections.unmodifiableList(Arrays.asList(PKCSObjectIdentifiers.id_aa_signingCertificate.getId(), PKCSObjectIdentifiers.id_aa_signingCertificateV2.getId()));
    protected static final List<QName> NODENAMES = Collections.unmodifiableList(Arrays.asList(new QName("http://uri.etsi.org/01903/v1.3.2#", "SigningCertificate"), new QName("http://uri.etsi.org/01903/v1.3.2#", "SigningCertificateV2")));
    private List<CertID> certIDs;
    private String digestAlgorithmURI;

    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }

    public void setDigestAlgorithmURI(String digestAlgorithmURI) {
        this.digestAlgorithmURI = SigningCertificate.checkDigestAlgorithmArgument(digestAlgorithmURI);
    }

    private static String checkDigestAlgorithmArgument(String digestAlgorithmURI) {
        if (digestAlgorithmURI == null || digestAlgorithmURI.isEmpty()) {
            throw new IllegalArgumentException("digest algorithm required");
        }
        String jceDigestAlgorithm = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(digestAlgorithmURI);
        if (jceDigestAlgorithm == null) {
            throw new IllegalArgumentException("digest algorithm not mappable to a JCE algorithm: " + digestAlgorithmURI);
        }
        return digestAlgorithmURI;
    }

    public SigningCertificate(boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(null, useDefaultEncoding, encodings);
    }

    public SigningCertificate(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(null, useDefaultEncoding, encodings);
    }

    public SigningCertificate(List<CertID> certIDs, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(certIDs, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public SigningCertificate(List<CertID> certIDs, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncoding, encodings);
        this.setCertIDs(certIDs);
    }

    private static List<CertID> check(List<CertID> certIDs) {
        ArrayList<CertID> lCertIDs;
        ArrayList<CertID> arrayList = lCertIDs = certIDs == null || certIDs.isEmpty() ? null : new ArrayList<CertID>(certIDs);
        if (lCertIDs != null) {
            while (lCertIDs.contains(null)) {
                lCertIDs.remove(null);
            }
        }
        if (lCertIDs != null && lCertIDs.isEmpty()) {
            return null;
        }
        return lCertIDs;
    }

    public SigningCertificate(List<CertID> certIDs, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(certIDs, true, encodings);
    }

    public SigningCertificate(List<CertID> certIDs, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(certIDs, true, encodings);
    }

    public SigningCertificate(ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(null, true, Arrays.asList(encodings));
    }

    public SigningCertificate(List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(null, true, encodings);
    }

    public List<CertID> getCertIDs() {
        return this.certIDs;
    }

    public synchronized SigningCertificate addCertificate(Certificate certificate) {
        if (certificate == null) {
            return this;
        }
        if (this.digestAlgorithmURI == null) {
            throw new IllegalStateException("valid digest algorithm URI not present currently, please set digest algorithm previously");
        }
        if (this.certIDs == null) {
            this.certIDs = new ArrayList<CertID>();
        }
        this.certIDs.add(new CertID(this.digestAlgorithmURI, (X509Certificate)certificate));
        return this;
    }

    public synchronized SigningCertificate addCertificate(CertificateValue certificate) {
        if (certificate == null) {
            return this;
        }
        this.addCertificate(certificate.certificate());
        return this;
    }

    public SigningCertificate setCertIDs(List<CertID> certIDs) {
        this.certIDs = SigningCertificate.check(certIDs);
        return this;
    }

    @Override
    public final List<String> getOIDs() {
        return OIDS;
    }

    @Override
    public final List<QName> getNodeNames() {
        return NODENAMES;
    }
}

