/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AbstractSignedProperty;
import de.governikus.csl.uom.sign.props.CertifiedRole;
import de.governikus.csl.uom.sign.props.ClaimedRole;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SignerRole
extends AbstractSignedProperty {
    private static final List<String> OIDs = Collections.singletonList(PKCSObjectIdentifiers.id_aa_ets_signerAttr.getId());
    private static final List<QName> NODENAMES = Collections.unmodifiableList(Arrays.asList(new QName("http://uri.etsi.org/01903/v1.3.2#", "SignerRole"), new QName("http://uri.etsi.org/01903/v1.3.2#", "SignerRoleV2")));
    private final List<CertifiedRole> certifiedRoles;
    private final List<ClaimedRole> claimedRoles;

    private static <T> List<T> copyList(List<T> list) {
        ArrayList result = list == null ? new ArrayList() : new ArrayList<T>(list);
        result.remove(null);
        return result;
    }

    public SignerRole(boolean useDefaultEncoding, CertifiedRole ... certifiedRoles) {
        this(useDefaultEncoding, null, null, Arrays.asList(certifiedRoles));
    }

    public SignerRole(boolean useDefaultEncoding, CertifiedRole certifiedRole, ClaimedRole ... claimedRoles) {
        this(useDefaultEncoding, null, Arrays.asList(claimedRoles), Collections.singletonList(certifiedRole));
    }

    public SignerRole(boolean useDefaultEncoding, ClaimedRole ... claimedRoles) {
        this(useDefaultEncoding, null, Arrays.asList(claimedRoles), null);
    }

    public SignerRole(boolean useDefaultEncoding, ClaimedRole claimedRole, CertifiedRole ... certifiedRoles) {
        this(useDefaultEncoding, null, Collections.singletonList(claimedRole), Arrays.asList(certifiedRoles));
    }

    public SignerRole(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings, CertifiedRole ... certifiedRoles) {
        this(useDefaultEncoding, encodings, null, Arrays.asList(certifiedRoles));
    }

    public SignerRole(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings, CertifiedRole certifiedRole, ClaimedRole ... claimedRoles) {
        this(useDefaultEncoding, encodings, Arrays.asList(claimedRoles), Collections.singletonList(certifiedRole));
    }

    public SignerRole(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings, ClaimedRole ... claimedRoles) {
        this(useDefaultEncoding, encodings, Arrays.asList(claimedRoles), null);
    }

    public SignerRole(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings, ClaimedRole claimedRole, CertifiedRole ... certifiedRoles) {
        this(useDefaultEncoding, encodings, Collections.singletonList(claimedRole), certifiedRoles == null ? null : Arrays.asList(certifiedRoles));
    }

    public SignerRole(List<CertifiedRole> certifiedRoles, ClaimedRole ... claimedRoles) {
        this(true, null, Arrays.asList(claimedRoles), certifiedRoles);
    }

    public SignerRole(List<ClaimedRole> claimedRoles, CertifiedRole ... certifiedRoles) {
        this(true, null, claimedRoles, Arrays.asList(certifiedRoles));
    }

    public SignerRole(List<ClaimedRole> claimedRoles, List<CertifiedRole> certifiedRoles) {
        this(true, null, claimedRoles, certifiedRoles);
    }

    public SignerRole(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings, List<ClaimedRole> claimedRoles) {
        this(useDefaultEncoding, encodings, claimedRoles, null);
    }

    public SignerRole(boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings, List<ClaimedRole> claimedRoles, List<CertifiedRole> certifiedRoles) {
        super(useDefaultEncoding, encodings);
        this.claimedRoles = Collections.unmodifiableList(SignerRole.copyList(claimedRoles));
        this.certifiedRoles = Collections.unmodifiableList(SignerRole.copyList(certifiedRoles));
        if (this.claimedRoles.isEmpty() && this.certifiedRoles.isEmpty()) {
            throw new IllegalArgumentException("no role defined");
        }
    }

    public SignerRole(CertifiedRole ... certifiedRoles) {
        this(true, null, null, Arrays.asList(certifiedRoles));
    }

    public SignerRole(CertifiedRole certifiedRole, ClaimedRole ... claimedRoles) throws IllegalArgumentException {
        this(true, null, Arrays.asList(claimedRoles), Collections.singletonList(certifiedRole));
    }

    public SignerRole(ClaimedRole ... claimedRoles) throws IllegalArgumentException {
        this(true, null, Arrays.asList(claimedRoles), null);
    }

    public SignerRole(ClaimedRole claimedRole, CertifiedRole ... certifiedRoles) throws IllegalArgumentException {
        this(true, null, Collections.singletonList(claimedRole), Arrays.asList(certifiedRoles));
    }

    public List<CertifiedRole> getCertifiedRoles() {
        return this.certifiedRoles;
    }

    public List<ClaimedRole> getClaimedRoles() {
        return this.claimedRoles;
    }

    @Override
    public final List<String> getOIDs() {
        return OIDs;
    }

    @Override
    public final List<QName> getNodeNames() {
        return NODENAMES;
    }
}

