/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.sign.SignPropertySortMechanism;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.UnsignedProperty;
import de.governikus.csl.uom.sign.ades.DefaultAdESSignPropertySortMechanism;
import de.governikus.csl.uom.sign.props.PropertiesUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SignPropertySortMechanismRegistry {
    private static SignPropertySortMechanismRegistry registry;
    private final Map<String, SignPropertySortMechanism> sortMechanisms = new LinkedHashMap<String, SignPropertySortMechanism>();
    private final Set<String> unmodifiableSortMechanismKeys;
    public static final String DEFAULT_SORT_MECHANISM_NAME_NO_CHANGE = "SORTER_NO_CHANGE";
    public static final SignPropertySortMechanism DEFAULT_SORT_MECHANISM_NO_CHANGE;

    private SignPropertySortMechanismRegistry() {
        this.registerInt(DEFAULT_SORT_MECHANISM_NO_CHANGE.getName(), DEFAULT_SORT_MECHANISM_NO_CHANGE);
        this.register(DefaultAdESSignPropertySortMechanism.DEFAULT);
        this.unmodifiableSortMechanismKeys = Collections.unmodifiableSet(this.sortMechanisms.keySet());
    }

    public Set<String> getNames() {
        return this.unmodifiableSortMechanismKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignPropertySortMechanism getSortMechanism(String name) {
        String lName = name;
        if (name == null || name.isEmpty() || DEFAULT_SORT_MECHANISM_NAME_NO_CHANGE.equals(name)) {
            return DEFAULT_SORT_MECHANISM_NO_CHANGE;
        }
        SignPropertySortMechanism result = null;
        Map<String, SignPropertySortMechanism> map = this.sortMechanisms;
        synchronized (map) {
            result = this.sortMechanisms.get(lName);
        }
        if (result == null) {
            return DEFAULT_SORT_MECHANISM_NO_CHANGE;
        }
        return result;
    }

    public SignPropertySortMechanismRegistry register(SignPropertySortMechanism sortMechanism) {
        if (sortMechanism == null) {
            return this;
        }
        String name = sortMechanism.getName();
        if (name == null || name.isEmpty() || DEFAULT_SORT_MECHANISM_NAME_NO_CHANGE.equals(name)) {
            return this;
        }
        return this.registerInt(name, sortMechanism);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignPropertySortMechanismRegistry registerInt(String name, SignPropertySortMechanism sortMechanism) {
        Map<String, SignPropertySortMechanism> map = this.sortMechanisms;
        synchronized (map) {
            this.sortMechanisms.put(name, sortMechanism);
        }
        return this;
    }

    public SignPropertySortMechanismRegistry unregister(SignPropertySortMechanism sortMechanism) {
        if (sortMechanism == null) {
            return this;
        }
        return this.unregister(sortMechanism.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignPropertySortMechanismRegistry unregister(String name) {
        if (name == null || name.isEmpty() || DEFAULT_SORT_MECHANISM_NAME_NO_CHANGE.equals(name)) {
            return this;
        }
        Map<String, SignPropertySortMechanism> map = this.sortMechanisms;
        synchronized (map) {
            this.sortMechanisms.remove(name);
        }
        return this;
    }

    public static synchronized SignPropertySortMechanismRegistry getRegistry() {
        if (registry == null) {
            registry = new SignPropertySortMechanismRegistry();
        }
        return registry;
    }

    static {
        DEFAULT_SORT_MECHANISM_NO_CHANGE = new SignPropertySortMechanism(){

            @Override
            public String getName() {
                return SignPropertySortMechanismRegistry.DEFAULT_SORT_MECHANISM_NAME_NO_CHANGE;
            }

            @Override
            public Comparator<SignedProperty> getSignedPropertyComparator() {
                return PropertiesUtil.noChangeComparator();
            }

            @Override
            public Comparator<UnsignedProperty> getUnsignedPropertyComparator() {
                return PropertiesUtil.noChangeComparator();
            }
        };
    }
}

