/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.res.CertificateValidationServiceResourceReferenceParameter;
import de.governikus.csl.uom.res.TrustedAnchorServiceResourceReferenceParameter;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AbstractUnsignedProperty;
import java.security.cert.CRL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class RevocationValues
extends AbstractUnsignedProperty {
    public static final List<String> OIDS = Collections.singletonList(PKCSObjectIdentifiers.id_aa_ets_revocationValues.getId());
    public static final List<QName> NODENAMES = Collections.singletonList(new QName("http://uri.etsi.org/01903/v1.3.2#", "RevocationValues"));
    private final boolean crlsUsed;
    private final boolean ocspResponsesUsed;
    private final List<OCSPResp> ocspResps;
    private final List<CRL> cRLs;
    private CertificateValidationServiceResourceReferenceParameter certificateValidationService;
    private TrustedAnchorServiceResourceReferenceParameter trustedAnchorService;

    public RevocationValues(boolean ocspResponsesUsed, boolean crlsUsed) {
        this(ocspResponsesUsed, crlsUsed, true, (List<ConstraintSignPolicy.EncodingConstraint>)null);
    }

    public RevocationValues(boolean ocspResponsesUsed, boolean crlsUsed, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(ocspResponsesUsed, crlsUsed, true, encodings);
    }

    public RevocationValues(boolean ocspResponsesUsed, boolean crlsUsed, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(ocspResponsesUsed, crlsUsed, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public RevocationValues(boolean ocspResponsesUsed, boolean crlsUsed, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncoding, encodings);
        this.ocspResponsesUsed = ocspResponsesUsed;
        this.crlsUsed = crlsUsed;
        this.ocspResps = null;
        this.cRLs = null;
    }

    public RevocationValues(List<OCSPResp> ocspResponses, List<CRL> cRLs, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncoding, encodings);
        this.ocspResponsesUsed = ocspResponses != null && !ocspResponses.isEmpty();
        this.crlsUsed = cRLs != null && !cRLs.isEmpty();
        this.ocspResps = ocspResponses;
        this.cRLs = cRLs;
    }

    public boolean areCRLsUsed() {
        return this.crlsUsed;
    }

    public boolean areOCSPResponsesUsed() {
        return this.ocspResponsesUsed;
    }

    public List<OCSPResp> getOCSPResponses() {
        return this.ocspResps;
    }

    public List<CRL> getCRLs() {
        return this.cRLs;
    }

    public CertificateValidationServiceResourceReferenceParameter getCertificateValidationService() {
        return this.certificateValidationService;
    }

    public void setCertificateValidationService(CertificateValidationServiceResourceReferenceParameter certificateValidationService) {
        this.certificateValidationService = certificateValidationService;
    }

    public TrustedAnchorServiceResourceReferenceParameter getTrustedAnchorService() {
        return this.trustedAnchorService;
    }

    public void setTrustedAnchorService(TrustedAnchorServiceResourceReferenceParameter trustedAnchorService) {
        this.trustedAnchorService = trustedAnchorService;
    }

    @Override
    public final List<String> getOIDs() {
        return OIDS;
    }

    @Override
    public final List<QName> getNodeNames() {
        return NODENAMES;
    }
}

