/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SignPropertySortMechanism;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.sign.UnsignedProperty;
import de.governikus.csl.uom.sign.ades.DefaultAdESSignedPropertySorter;
import de.governikus.csl.uom.sign.ades.DefaultAdESUnsignedPropertySorter;
import de.governikus.csl.uom.sign.props.SignPropertySortMechanismRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class PropertiesUtil {
    public static final Comparator<SignedProperty> DEFAULT_ADES_SIGNED_PROPERTIES_SORTER = DefaultAdESSignedPropertySorter.DEFAULT;
    public static final Comparator<UnsignedProperty> DEFAULT_ADES_UNSIGNED_PROPERTIES_SORTER = DefaultAdESUnsignedPropertySorter.DEFAULT;
    public static final Comparator COMPARATOR_NO_CHANGE = new Comparator(){

        public int compare(Object o1, Object o2) {
            return 0;
        }
    };

    private PropertiesUtil() {
    }

    public static <T extends UnsignedProperty> List<T> findUnsignedProperties(Class<T> propertyClass, SignerInfo signerInfo) {
        return PropertiesUtil.findUnsignedProperties(propertyClass, signerInfo == null ? null : signerInfo.getUnsignedProperties());
    }

    public static <T extends UnsignedProperty> List<T> findUnsignedProperties(Class<T> propertyClass, UnsignedProperties unsignedProperties) {
        return PropertiesUtil.findProperties(propertyClass, unsignedProperties);
    }

    public static <T extends SignedProperty> List<T> findSignedProperties(Class<T> propertyClass, SignerInfo signerInfo) {
        return PropertiesUtil.findSignedProperties(propertyClass, signerInfo == null ? null : signerInfo.getSignedProperties());
    }

    public static <T extends SignedProperty> List<T> findSignedProperties(Class<T> propertyClass, SignedProperties signedProperties) {
        return PropertiesUtil.findProperties(propertyClass, signedProperties);
    }

    public static <T extends SignProperty, P extends T> List<P> findProperties(Class<P> propertyClass, List<? extends T> properties) {
        ArrayList<P> result = new ArrayList<P>();
        if (propertyClass == null) {
            return result;
        }
        if (properties == null || properties.isEmpty()) {
            return result;
        }
        for (SignProperty signProperty : properties) {
            if (!propertyClass.isInstance(signProperty)) continue;
            result.add(propertyClass.cast(signProperty));
        }
        return result;
    }

    public static <T extends UnsignedProperty> T getUnsignedProperty(Class<T> propertyClass, SignerInfo signerInfo, boolean remove) {
        if (signerInfo == null) {
            return null;
        }
        return (T)((UnsignedProperty)PropertiesUtil.getProperty(propertyClass, signerInfo.getUnsignedProperties(), remove));
    }

    public static <T extends SignedProperty> T getSignedProperty(Class<T> propertyClass, SignerInfo signerInfo, boolean remove) {
        if (signerInfo == null) {
            return null;
        }
        return (T)((SignedProperty)PropertiesUtil.getProperty(propertyClass, signerInfo.getSignedProperties(), remove));
    }

    public static <T extends UnsignedProperty> T getUnsignedProperty(Class<T> propertyClass, UnsignedProperties unsignedProperties, boolean remove) {
        return (T)((UnsignedProperty)PropertiesUtil.getProperty(propertyClass, unsignedProperties, remove));
    }

    public static <T extends SignedProperty> T getSignedProperty(Class<T> propertyClass, SignedProperties signedProperties, boolean remove) {
        return (T)((SignedProperty)PropertiesUtil.getProperty(propertyClass, signedProperties, remove));
    }

    public static <T extends SignProperty, P extends T> P getProperty(Class<P> propertyClass, List<? extends T> properties, boolean remove) {
        if (propertyClass == null) {
            return null;
        }
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        List<P> result = PropertiesUtil.findProperties(propertyClass, properties);
        if (result.isEmpty()) {
            return null;
        }
        if (remove) {
            PropertiesUtil.removeProperties(properties, propertyClass);
        }
        return (P)((SignProperty)result.get(0));
    }

    @SafeVarargs
    public static <T extends SignProperty> List<T> removeProperties(List<T> properties, Class<? extends T> ... propertyClasses) {
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        if (propertyClasses == null || propertyClasses.length == 0) {
            return properties;
        }
        for (Class<? extends T> propertyClass : propertyClasses) {
            List<T> result;
            if (propertyClass == null || (result = PropertiesUtil.findProperties(propertyClass, properties)).isEmpty()) continue;
            properties.removeAll(result);
        }
        return properties;
    }

    public static <T extends UnsignedProperty> boolean existsUnsignedProperties(Class<T> propertyClass, SignerInfo signerInfo) {
        return PropertiesUtil.existsUnsignedProperties(propertyClass, signerInfo == null ? null : signerInfo.getUnsignedProperties());
    }

    public static <T extends UnsignedProperty> boolean existsUnsignedProperties(Class<T> propertyClass, UnsignedProperties unsignedProperties) {
        return !PropertiesUtil.findProperties(propertyClass, unsignedProperties).isEmpty();
    }

    public static <T extends SignedProperty> boolean existsSignedProperties(Class<T> propertyClass, SignerInfo signerInfo) {
        return PropertiesUtil.existsSignedProperties(propertyClass, signerInfo == null ? null : signerInfo.getSignedProperties());
    }

    public static <T extends SignedProperty> boolean existsSignedProperties(Class<T> propertyClass, SignedProperties signedProperties) {
        return !PropertiesUtil.findProperties(propertyClass, signedProperties).isEmpty();
    }

    public static SignedProperties sort(SignedProperties signedProperties) {
        return PropertiesUtil.sort(signedProperties, DEFAULT_ADES_SIGNED_PROPERTIES_SORTER);
    }

    public static <T extends List<SignedProperty>> T sortSignedProperties(T signedProperties) {
        return PropertiesUtil.sort(signedProperties, DEFAULT_ADES_SIGNED_PROPERTIES_SORTER);
    }

    public static UnsignedProperties sort(UnsignedProperties unsignedProperties) {
        return PropertiesUtil.sort(unsignedProperties, DEFAULT_ADES_UNSIGNED_PROPERTIES_SORTER);
    }

    public static <T extends List<UnsignedProperty>> T sortUnsignedProperties(T unsignedProperties) {
        return PropertiesUtil.sort(unsignedProperties, DEFAULT_ADES_UNSIGNED_PROPERTIES_SORTER);
    }

    public static <T extends SignProperty, S extends List<T>> S sort(S signProperties, Comparator<T> comparator) {
        if (comparator == null || signProperties == null || signProperties.isEmpty()) {
            return signProperties;
        }
        signProperties.sort(comparator);
        return signProperties;
    }

    public static <C> Comparator<C> noChangeComparator() {
        return COMPARATOR_NO_CHANGE;
    }

    public static void sort(SignerInfo signerInfo, SignPolicy signPolicy) throws CoreException {
        if (signerInfo == null) {
            return;
        }
        String sortMechanismName = ConstraintSignPolicy.class.isInstance(signPolicy) ? ((ConstraintSignPolicy)ConstraintSignPolicy.class.cast(signPolicy)).getSortMechanismName() : null;
        PropertiesUtil.sort(signerInfo, SignPropertySortMechanismRegistry.getRegistry().getSortMechanism(sortMechanismName));
    }

    public static void sort(SignerInfo signerInfo, SignPropertySortMechanism sortMechanism) throws CoreException {
        if (signerInfo == null || sortMechanism == null) {
            return;
        }
        try {
            PropertiesUtil.sort(signerInfo.getSignedProperties(), sortMechanism.getSignedPropertyComparator());
            PropertiesUtil.sort(signerInfo.getUnsignedProperties(), sortMechanism.getUnsignedPropertyComparator());
        }
        catch (Exception e) {
            throw new CoreException("failed sorting properties" + e.getMessage(), (Throwable)e);
        }
    }
}

