/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AbstractSignedProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class ProductionPlace
extends AbstractSignedProperty {
    protected static final List<String> OIDS = Collections.singletonList(PKCSObjectIdentifiers.id_aa_ets_signerLocation.getId());
    protected static final List<QName> NODENAMES = Collections.unmodifiableList(Arrays.asList(new QName("http://uri.etsi.org/01903/v1.3.2#", "SignatureProductionPlace"), new QName("http://uri.etsi.org/01903/v1.3.2#", "SignatureProductionPlaceV2")));
    private final String city;
    private final String countryName;
    private final String postalCode;
    private final String stateOrProvince;
    private final String streetAddress;

    public ProductionPlace(String city, String countryName, String postalCode, String stateOrProvince, String streetAddress, boolean useDefaultEncodingVersion, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncodingVersion, encodings);
        this.city = city;
        this.countryName = countryName;
        this.postalCode = postalCode;
        this.stateOrProvince = stateOrProvince;
        this.streetAddress = streetAddress;
    }

    public ProductionPlace(String city, String countryName, String postalCode, String stateOrProvince, String streetAddress) {
        this(city, countryName, postalCode, stateOrProvince, streetAddress, true, new ConstraintSignPolicy.EncodingConstraint[0]);
    }

    public ProductionPlace(String city, String countryName, String postalCode, String stateOrProvince, String streetAddress, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(city, countryName, postalCode, stateOrProvince, streetAddress, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public ProductionPlace(String city, String countryName, String postalCode, String stateOrProvince, String streetAddress, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(city, countryName, postalCode, stateOrProvince, streetAddress, true, encodings);
    }

    public ProductionPlace(String city, String countryName, String postalCode, String stateOrProvince, String streetAddress, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(city, countryName, postalCode, stateOrProvince, streetAddress, true, encodings);
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public String toString() {
        return super.toString() + "(" + this.toPDFSignerLocation() + ")";
    }

    public String toPDFSignerLocation() {
        return (this.postalCode == null || this.postalCode.isEmpty() ? "" : this.postalCode + " ") + (this.city == null || this.city.isEmpty() ? "" : this.city) + (this.stateOrProvince == null || this.stateOrProvince.isEmpty() ? "" : " (" + this.stateOrProvince + ")") + (this.streetAddress == null || this.streetAddress.isEmpty() ? "" : ", " + this.streetAddress) + (this.countryName == null || this.countryName.isEmpty() ? "" : ", " + this.countryName);
    }

    @Override
    public final List<String> getOIDs() {
        return OIDS;
    }

    @Override
    public final List<QName> getNodeNames() {
        return NODENAMES;
    }
}

