/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AbstractSignedProperty;
import de.governikus.csl.uom.sign.props.PropertyConstants;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;

public class CertifiedRole
extends AbstractSignedProperty {
    protected static final List<String> OIDS = PropertyConstants.CMS_EMPTY_OIDs;
    protected static final List<QName> NODE_NAMES = Collections.unmodifiableList(Arrays.asList(new QName("http://uri.etsi.org/01903/v1.3.2#", "SignerRole"), new QName("http://uri.etsi.org/01903/v1.3.2#", "SignerRoleV2")));
    private final String id;
    private final String encoding;
    private final byte[] data;

    public CertifiedRole(String id, String encoding, byte[] data) {
        this(id, encoding, data, true, new ConstraintSignPolicy.EncodingConstraint[0]);
    }

    public CertifiedRole(String id, String encoding, byte[] data, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(id, encoding, data, true, encodings);
    }

    public CertifiedRole(String id, String encoding, byte[] data, boolean useDefaultEncoding, ConstraintSignPolicy.EncodingConstraint ... encodings) {
        this(id, encoding, data, useDefaultEncoding, encodings == null ? null : Arrays.asList(encodings));
    }

    public CertifiedRole(String id, String encoding, byte[] data, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        this(id, encoding, data, true, encodings);
    }

    public CertifiedRole(String id, String encoding, byte[] data, boolean useDefaultEncoding, List<ConstraintSignPolicy.EncodingConstraint> encodings) {
        super(useDefaultEncoding, encodings);
        this.id = id;
        this.encoding = encoding;
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data required");
        }
        this.data = data;
    }

    public String getId() {
        return this.id;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public final List<String> getOIDs() {
        return OIDS;
    }

    @Override
    public final List<QName> getNodeNames() {
        return NODE_NAMES;
    }
}

